/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.auth;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.util.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;

public class NTLM2Scheme
extends NTLMScheme {
    private static final Logger LOG = Logger.getInstance((String)NTLM2Scheme.class.getName());
    private static final int MESSAGE_1_DEFAULT_FLAGS = Type1Message.getDefaultFlags() | NTLM2Scheme.readUserFlags("org.jetbrains.tfsIntegration.webservice.auth.ntlm.message1flags");
    private static final int MESSAGE_3_DEFAULT_FLAGS;
    private String ntlmchallenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int TYPE1_MSG_GENERATED = 2;
    private static final int TYPE2_MSG_RECEIVED = 3;
    private static final int TYPE3_MSG_GENERATED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private int state;

    private static int readUserFlags(String key) {
        String flagsStr = System.getProperty(key);
        if (flagsStr != null && flagsStr.startsWith("0x")) {
            try {
                return (int)Long.parseLong(flagsStr.substring("0x".length()), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public NTLM2Scheme() {
        this.state = 0;
    }

    public NTLM2Scheme(String challenge) throws MalformedChallengeException {
        this.processChallenge(challenge);
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        String s = AuthChallengeParser.extractScheme((String)challenge);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid NTLM challenge: " + challenge);
        }
        int i = challenge.indexOf(32);
        if (i != -1) {
            s = challenge.substring(i, challenge.length());
            this.ntlmchallenge = s.trim();
            this.state = 3;
        } else {
            this.ntlmchallenge = "";
            this.state = this.state == 0 ? 1 : Integer.MAX_VALUE;
        }
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "ntlm";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        return this.ntlmchallenge;
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        String response;
        if (this.state == 0) {
            throw new IllegalStateException("NTLM authentication process was not initiated");
        }
        NTCredentials ntcredentials = null;
        try {
            ntcredentials = (NTCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for NTLM authentication: " + credentials.getClass().getName());
        }
        if (this.state == 1 || this.state == Integer.MAX_VALUE) {
            response = this.getType1MessageResponse(ntcredentials, method.getParams());
            this.state = 2;
        } else {
            response = this.getType3MessageResponse(this.ntlmchallenge, ntcredentials, method.getParams());
            this.state = 4;
        }
        return "NTLM " + response;
    }

    protected String getType1MessageResponse(NTCredentials ntcredentials, HttpMethodParams params) {
        Type1Message t1m = new Type1Message(MESSAGE_1_DEFAULT_FLAGS, ntcredentials.getDomain(), Workstation.getComputerName());
        return Base64.encode((byte[])t1m.toByteArray());
    }

    protected String getType3MessageResponse(String type2message, NTCredentials ntcredentials, HttpMethodParams params) throws AuthenticationException {
        Type2Message t2m;
        try {
            t2m = new Type2Message(Base64.decode((String)type2message));
        }
        catch (IOException ex) {
            throw new AuthenticationException("Invalid Type2 message", (Throwable)ex);
        }
        Type3Message t3m = new Type3Message(t2m, ntcredentials.getPassword(), ntcredentials.getDomain(), ntcredentials.getUserName(), Workstation.getComputerName(), MESSAGE_3_DEFAULT_FLAGS);
        return Base64.encode((byte[])t3m.toByteArray());
    }

    static {
        LOG.info("Message 1 flags: 0x" + Integer.toHexString(MESSAGE_1_DEFAULT_FLAGS));
        MESSAGE_3_DEFAULT_FLAGS = Type3Message.getDefaultFlags() | NTLM2Scheme.readUserFlags("org.jetbrains.tfsIntegration.webservice.auth.ntlm.message3flags");
        LOG.info("Message 3 flags: 0x" + Integer.toHexString(MESSAGE_3_DEFAULT_FLAGS));
    }
}

