/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.webservice.compatibility;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.exception.OMBuilderException;
import org.apache.axiom.soap.SOAPProcessingException;
import org.jetbrains.tfsIntegration.webservice.compatibility.CustomStAXSOAPModelBuilder;

public abstract class CustomSOAPBuilderHelper {
    protected CustomStAXSOAPModelBuilder builder;
    protected XMLStreamReader parser;

    protected CustomSOAPBuilderHelper(CustomStAXSOAPModelBuilder builder) {
        this.builder = builder;
    }

    public abstract OMElement handleEvent(XMLStreamReader var1, OMElement var2, int var3) throws SOAPProcessingException;

    protected void processNamespaceData(OMElement node, boolean checkSOAPNamespace) {
        int namespaceCount = this.parser.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespaceURI = this.parser.getNamespaceURI(i);
            if (namespaceURI == null) continue;
            node.declareNamespace(this.parser.getNamespaceURI(i), this.parser.getNamespacePrefix(i));
        }
        String namespaceURI = this.parser.getNamespaceURI();
        String prefix = this.parser.getPrefix();
        OMNamespace namespace = null;
        if (namespaceURI != null && namespaceURI.length() > 0) {
            if (prefix == null) {
                namespace = node.findNamespace(namespaceURI, "");
                if (namespace == null) {
                    namespace = node.declareNamespace(namespaceURI, "");
                }
            } else {
                namespace = node.findNamespace(namespaceURI, prefix);
            }
            node.setNamespace(namespace);
        }
        if (checkSOAPNamespace && node.getNamespace() != null && !node.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") && !node.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
            throw new OMBuilderException("invalid SOAP namespace URI");
        }
    }

    protected void processAttributes(OMElement node) {
        int attribCount = this.parser.getAttributeCount();
        for (int i = 0; i < attribCount; ++i) {
            OMNamespace ns = null;
            String uri = this.parser.getAttributeNamespace(i);
            if (uri != null && uri.hashCode() != 0) {
                ns = node.findNamespace(uri, this.parser.getAttributePrefix(i));
            }
            node.addAttribute(this.parser.getAttributeLocalName(i), this.parser.getAttributeValue(i), ns);
        }
    }
}

