/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.net.PasswordAuthentication;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AuthenticationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JTextField userNameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private PasswordAuthentication authentication;

    public AuthenticationDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public AuthenticationDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private void init() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FlowLayout());
        Box rootBox = new Box(1);
        rootBox.setBorder(new EmptyBorder(4, 4, 4, 4));
        Box userNameBox = new Box(0);
        JLabel userNameLabel = new JLabel("User name:");
        int unph = userNameLabel.getPreferredSize().height;
        userNameLabel.setPreferredSize(new Dimension(100, unph));
        userNameLabel.setHorizontalAlignment(4);
        userNameBox.add(userNameLabel);
        userNameBox.add(Box.createRigidArea(new Dimension(4, 1)));
        userNameBox.add(this.userNameField);
        userNameBox.setPreferredSize(new Dimension(300, unph + 4));
        Box passwordBox = new Box(0);
        JLabel passwordLabel = new JLabel("Password:");
        int pwph = passwordLabel.getPreferredSize().height;
        passwordLabel.setPreferredSize(new Dimension(100, pwph));
        passwordLabel.setHorizontalAlignment(4);
        passwordBox.add(passwordLabel);
        passwordBox.add(Box.createRigidArea(new Dimension(4, 1)));
        passwordBox.add(this.passwordField);
        passwordBox.setPreferredSize(new Dimension(300, pwph + 4));
        Box buttonBox = new Box(0);
        JButton okButton = new JButton();
        okButton.setAction(new OkAction());
        okButton.setText("OK");
        JButton cancelButton = new JButton();
        cancelButton.setAction(new CancelAction());
        cancelButton.setText("Cancel");
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(okButton);
        buttonBox.add(Box.createHorizontalStrut(4));
        buttonBox.add(cancelButton);
        buttonBox.add(Box.createHorizontalGlue());
        rootBox.add(userNameBox);
        rootBox.add(Box.createVerticalStrut(2));
        rootBox.add(passwordBox);
        rootBox.add(Box.createVerticalStrut(4));
        rootBox.add(buttonBox);
        contentPane.add(rootBox);
    }

    public void setUserName(String userName) {
        this.userNameField.setText(userName);
        this.passwordField.grabFocus();
    }

    public PasswordAuthentication getAuthentication() {
        return this.authentication;
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AuthenticationDialog.this.authentication = null;
            AuthenticationDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AuthenticationDialog.this.authentication = new PasswordAuthentication(AuthenticationDialog.this.userNameField.getText(), AuthenticationDialog.this.passwordField.getPassword());
            AuthenticationDialog.this.dispose();
        }
    }
}

