/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.control;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.transcoder.TranscoderException;
import org.lobobrowser.html.control.BaseInputControl;
import org.lobobrowser.html.dombl.ImageEvent;
import org.lobobrowser.html.dombl.ImageListener;
import org.lobobrowser.html.dombl.SVGRasterizer;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.util.gui.WrapperLayout;

public class InputImageControl
extends BaseInputControl
implements ImageListener {
    private static final long serialVersionUID = 1L;
    private int valign = 5;
    private Dimension preferredSize;
    private int declaredWidth;
    private int declaredHeight;
    private Image image;
    private boolean mouseBeingPressed;
    private String alt;

    public InputImageControl(final HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        this.alt = modelNode.getAlt();
        modelNode.addImageListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InputImageControl.this.mouseBeingPressed = true;
                InputImageControl.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InputImageControl.this.mouseBeingPressed = false;
                InputImageControl.this.repaint();
                HtmlController.getInstance().onPressed(modelNode, e, e.getX(), e.getY());
            }
        });
        if (modelNode.getSrc().contains("svg")) {
            try {
                URL u = new URL(modelNode.getSrc());
                SVGRasterizer r = new SVGRasterizer(u);
                r.setImageLoadedCallback(this);
                this.image = r.bufferedImageToImage();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            catch (TranscoderException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Color over;
        super.paintComponent(g);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Image image = this.image;
        if (image != null) {
            g.drawImage(image, insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom, this);
        } else {
            g.drawString(this.alt, 10, 10);
        }
        if (this.mouseBeingPressed && (over = new Color(255, 100, 100, 64)) != null) {
            Color oldColor = g.getColor();
            try {
                g.setColor(over);
                g.fillRect(0, 0, size.width, size.height);
            }
            finally {
                g.setColor(oldColor);
            }
        }
    }

    @Override
    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLElementImpl element = this.controlElement;
        int dw = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("width"), availWidth, -1);
        int dh = HtmlValues.getOldSyntaxPixelSize(element.getAttribute("height"), availHeight, -1);
        this.declaredWidth = dw;
        this.declaredHeight = dh;
        this.preferredSize = this.createPreferredSize(dw, dh);
        String alignText = element.getAttribute("align");
        int valign = alignText == null ? 5 : ("middle".equals(alignText = alignText.toLowerCase().trim()) ? 1 : ("absmiddle".equals(alignText) ? 3 : ("top".equals(alignText) ? 0 : ("bottom".equals(alignText) ? 2 : ("baseline".equals(alignText) ? 5 : ("absbottom".equals(alignText) ? 4 : 5))))));
        this.valign = valign;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = this.preferredSize;
        return ps == null ? new Dimension(0, 0) : ps;
    }

    public Dimension createPreferredSize(int dw, int dh) {
        Image img = this.image;
        if (dw == -1) {
            int n = dw = img == null ? -1 : img.getWidth(this);
            if (dw == -1) {
                dw = 0;
            }
        }
        if (dh == -1) {
            int n = dh = img == null ? -1 : img.getHeight(this);
            if (dh == -1) {
                dh = 0;
            }
        }
        return new Dimension(dw, dh);
    }

    private final boolean checkPreferredSizeChange() {
        Dimension newPs = this.createPreferredSize(this.declaredWidth, this.declaredHeight);
        Dimension ps = this.preferredSize;
        if (ps == null) {
            return true;
        }
        if (ps.width != newPs.width || ps.height != newPs.height) {
            this.preferredSize = newPs;
            return true;
        }
        return false;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!InputImageControl.this.checkPreferredSizeChange()) {
                        InputImageControl.this.repaint();
                    } else {
                        InputImageControl.this.ruicontrol.preferredSizeInvalidated();
                    }
                }
            });
        }
        return true;
    }

    public void imageUpdate(Image img, int w, int h) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!InputImageControl.this.checkPreferredSizeChange()) {
                    InputImageControl.this.repaint();
                } else {
                    InputImageControl.this.ruicontrol.preferredSizeInvalidated();
                }
            }
        });
    }

    @Override
    public boolean paintSelection(Graphics g, boolean inSelection, RenderableSpot startPoint, RenderableSpot endPoint) {
        return inSelection;
    }

    @Override
    public void imageLoaded(ImageEvent event) {
        Image image;
        this.image = image = event.image;
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width != -1 && height != -1) {
            this.imageUpdate(image, width, height);
        }
    }

    @Override
    public void resetInput() {
    }

    @Override
    public int getVAlign() {
        return this.valign;
    }
}

