/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.dombl;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JTextFieldImpl
extends JTextField {
    private static final long serialVersionUID = 1L;
    private Font originalFont;
    private Color originalForeground;
    private Color placeholderForeground = new Color(160, 160, 160);
    private boolean textWrittenIn;

    public JTextFieldImpl() {
    }

    public JTextFieldImpl(int columns) {
        super(columns);
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (!this.isTextWrittenIn()) {
            this.originalFont = f;
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (!this.isTextWrittenIn()) {
            this.originalForeground = fg;
        }
    }

    public Color getPlaceholderForeground() {
        return this.placeholderForeground;
    }

    public void setPlaceholderForeground(Color placeholderForeground) {
        this.placeholderForeground = placeholderForeground;
    }

    public boolean isTextWrittenIn() {
        return this.textWrittenIn;
    }

    public void setTextWrittenIn(boolean textWrittenIn) {
        this.textWrittenIn = textWrittenIn;
    }

    public void setPlaceholder(final String text) {
        this.customizeText(text);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.warn();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.warn();
            }

            public void warn() {
                if (JTextFieldImpl.this.getText().trim().length() != 0) {
                    JTextFieldImpl.this.setFont(JTextFieldImpl.this.originalFont);
                    JTextFieldImpl.this.setForeground(JTextFieldImpl.this.originalForeground);
                    JTextFieldImpl.this.setTextWrittenIn(true);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!JTextFieldImpl.this.isTextWrittenIn()) {
                    JTextFieldImpl.this.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (JTextFieldImpl.this.getText().trim().length() == 0) {
                    JTextFieldImpl.this.customizeText(text);
                }
            }
        });
    }

    private void customizeText(String text) {
        this.setText(text);
        this.setFont(new Font(this.getFont().getFamily(), 2, this.getFont().getSize()));
        this.setForeground(this.getPlaceholderForeground());
        this.setTextWrittenIn(false);
    }
}

