/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import org.lobobrowser.html.domimpl.DOMTextMetricsImpl;
import org.lobobrowser.html.domimpl.HTMLCanvasElementImpl;
import org.lobobrowser.html.w3c.CanvasGradient;
import org.lobobrowser.html.w3c.CanvasImageData;
import org.lobobrowser.html.w3c.CanvasPattern;
import org.lobobrowser.html.w3c.CanvasRenderingContext2D;
import org.lobobrowser.html.w3c.HTMLCanvasElement;
import org.lobobrowser.html.w3c.HTMLImageElement;
import org.lobobrowser.html.w3c.HTMLVideoElement;
import org.lobobrowser.html.w3c.TextMetrics;
import org.lobobrowser.util.gui.ColorFactory;

public class DOMCanvasImpl
implements CanvasRenderingContext2D,
CanvasGradient,
CanvasPattern {
    private HTMLCanvasElementImpl canvas;
    private ArrayList<int[]> listRectValues;
    private ArrayList<int[]> listStrokeRectValues;
    private ArrayList<Object[]> listTextValues;
    private int[] rectValues;
    private float[] fractions;
    private Color[] colors;
    private GeneralPath path;

    public DOMCanvasImpl(HTMLCanvasElementImpl canvas) {
        this.canvas = canvas;
        if (this.listRectValues == null) {
            this.listRectValues = new ArrayList();
        }
        if (this.listStrokeRectValues == null) {
            this.listStrokeRectValues = new ArrayList();
        }
        if (this.listTextValues == null) {
            this.listTextValues = new ArrayList();
        }
        if (this.path == null) {
            this.path = new GeneralPath();
        }
        if (this.fractions == null) {
            this.fractions = new float[3];
        }
        if (this.colors == null) {
            this.colors = new Color[3];
        }
    }

    @Override
    public HTMLCanvasElement getCanvas() {
        return this.canvas;
    }

    @Override
    public Object getFillStyle() {
        return this.canvas.getColor();
    }

    @Override
    public void setFillStyle(Object arg) {
        this.canvas.setColor(ColorFactory.getInstance().getColor(arg.toString()));
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public void setFont(String arg) {
    }

    @Override
    public int getGlobalAlpha() {
        return 0;
    }

    @Override
    public void setGlobalAlpha(int arg) {
    }

    @Override
    public String getGlobalCompositeOperation() {
        return null;
    }

    @Override
    public void setGlobalCompositeOperation(String arg) {
    }

    @Override
    public String getLineCap() {
        return null;
    }

    @Override
    public void setLineCap(String arg) {
    }

    @Override
    public String getLineJoin() {
        return null;
    }

    @Override
    public void setLineJoin(String arg) {
    }

    @Override
    public int getLineWidth() {
        return this.canvas.getLineWidth();
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.canvas.setLineWidth(lineWidth);
    }

    @Override
    public int getMiterLimit() {
        return 0;
    }

    @Override
    public void setMiterLimit(int arg) {
    }

    @Override
    public int getShadowBlur() {
        return 0;
    }

    @Override
    public void setShadowBlur(int arg) {
    }

    @Override
    public String getShadowColor() {
        return null;
    }

    @Override
    public void setShadowColor(String arg) {
    }

    @Override
    public int getShadowOffsetX() {
        return 0;
    }

    @Override
    public void setShadowOffsetX(int arg) {
    }

    @Override
    public int getShadowOffsetY() {
        return 0;
    }

    @Override
    public void setShadowOffsetY(int arg) {
    }

    @Override
    public Object getStrokeStyle() {
        return this.canvas.getColor();
    }

    @Override
    public void setStrokeStyle(Object arg) {
        if (arg instanceof CanvasGradient) {
            this.canvas.setFractions(this.fractions);
            this.canvas.setColors(this.colors);
        } else {
            this.canvas.setColor(ColorFactory.getInstance().getColor(arg.toString()));
        }
    }

    @Override
    public String getTextAlign() {
        return null;
    }

    @Override
    public void setTextAlign(String arg) {
    }

    @Override
    public String getTextBaseline() {
        return null;
    }

    @Override
    public void setTextBaseline(String arg) {
    }

    @Override
    public void arc(int x, int y, int radius, int startAngle, int endAngle, boolean anticlockwise) {
    }

    @Override
    public void arcTo(int x1, int y1, int x2, int y2, int radius) {
    }

    @Override
    public void beginPath() {
    }

    @Override
    public void bezierCurveTo(int cp1x, int cp1y, int cp2x, int cp2y, int x, int y) {
        this.path.curveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void clearShadow() {
    }

    @Override
    public void clip() {
    }

    @Override
    public void closePath() {
        this.path.closePath();
    }

    @Override
    public CanvasGradient createLinearGradient(Object x0, Object y0, Object x1, Object y1) {
        Double[] val = new Double[]{new Double(x0.toString()), new Double(y0.toString()), new Double(x1.toString()), new Double(y1.toString())};
        this.canvas.setLinearValues(val);
        return this;
    }

    @Override
    public CanvasPattern createPattern(HTMLCanvasElement canvas, String repetitionType) {
        return this;
    }

    @Override
    public CanvasPattern createPattern(HTMLImageElement image, String repetitionType) {
        return this;
    }

    @Override
    public CanvasGradient createRadialGradient(int x0, int y0, int r0, int x1, int y1, int r1) {
        return this;
    }

    @Override
    public void drawImage(HTMLImageElement image, int x, int y) {
    }

    @Override
    public void drawImage(HTMLImageElement image, int x, int y, int width, int height) {
    }

    @Override
    public void drawImage(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
    }

    @Override
    public void drawImage(HTMLCanvasElement canvas, int x, int y) {
    }

    @Override
    public void drawImage(HTMLCanvasElement canvas, int x, int y, int width, int height) {
    }

    @Override
    public void drawImage(HTMLCanvasElement canvas, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
    }

    @Override
    public void drawImage(HTMLVideoElement video, int x, int y) {
    }

    @Override
    public void drawImage(HTMLVideoElement video, int x, int y, int width, int height) {
    }

    @Override
    public void drawImage(HTMLVideoElement video, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx, int dy) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx, int dy, int dw) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
    }

    @Override
    public void drawImageFromRect(HTMLImageElement image, int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh, String compositeOperation) {
    }

    @Override
    public void fill() {
        this.fillRect(this.rectValues[0], this.rectValues[1], this.rectValues[2], this.rectValues[3]);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        int[] intArray = new int[]{x, y, width, height};
        this.listRectValues.add(intArray);
        this.canvas.setListRectValues(this.listRectValues);
        this.canvas.setMethod(1);
    }

    @Override
    public void fillText(String text, int x, int y) {
        this.fillText(text, x, y, 0);
    }

    @Override
    public void fillText(String text, int x, int y, int maxWidth) {
        Object[] objArray = new Object[]{text, x, y, maxWidth};
        this.listTextValues.add(objArray);
        this.canvas.setListTextValues(this.listTextValues);
        this.canvas.setColor(Color.BLACK);
        this.canvas.setMethod(2);
    }

    @Override
    public CanvasImageData getImageData(int sx, int sy, int sw, int sh) {
        return null;
    }

    @Override
    public boolean isPointInPath(int x, int y) {
        return false;
    }

    @Override
    public void lineTo(int x, int y) {
        this.path.lineTo(x, y);
    }

    @Override
    public TextMetrics measureText(String text) {
        return new DOMTextMetricsImpl(text);
    }

    @Override
    public void moveTo(int x, int y) {
        this.path.moveTo(x, y);
    }

    @Override
    public void putImageData(CanvasImageData imagedata, int dx, int dy) {
    }

    @Override
    public void putImageData(CanvasImageData imagedata, int dx, int dy, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
    }

    @Override
    public void quadraticCurveTo(int cpx, int cpy, int x, int y) {
    }

    @Override
    public void rect(int x, int y, int width, int height) {
        this.rectValues = new int[4];
        this.rectValues[0] = x;
        this.rectValues[1] = y;
        this.rectValues[2] = width;
        this.rectValues[3] = height;
    }

    @Override
    public void restore() {
    }

    @Override
    public void rotate(int angle) {
    }

    @Override
    public void save() {
    }

    @Override
    public void scale(int sx, int sy) {
    }

    @Override
    public void setAlpha(int alpha) {
    }

    @Override
    public void setCompositeOperation(String compositeOperation) {
    }

    @Override
    public void setShadow(int width, int height, int blur) {
    }

    @Override
    public void setShadow(int width, int height, int blur, String color) {
    }

    @Override
    public void setShadow(int width, int height, int blur, String color, int alpha) {
    }

    @Override
    public void setShadow(int width, int height, int blur, int grayLevel) {
    }

    @Override
    public void setShadow(int width, int height, int blur, int grayLevel, int alpha) {
    }

    @Override
    public void setShadow(int width, int height, int blur, int r, int g, int b, int a) {
    }

    @Override
    public void setShadow(int width, int height, int blur, int c, int m, int y, int k, int a) {
    }

    @Override
    public void setTransform(int m11, int m12, int m21, int m22, int dx, int dy) {
    }

    @Override
    public void stroke() {
        if (3 == this.canvas.getMethod()) {
            this.strokeRect(this.rectValues[0], this.rectValues[1], this.rectValues[2], this.rectValues[3], this.canvas.getLineWidth());
        } else {
            this.canvas.setMethod(5);
            this.canvas.setPath(this.path);
        }
    }

    @Override
    public void strokeRect(int x, int y, int width, int height) {
        this.strokeRect(x, y, width, height, this.canvas.getLineWidth());
    }

    @Override
    public void strokeRect(int x, int y, int width, int height, int lineWidth) {
        int[] intArray = new int[]{x, y, width, height, lineWidth};
        this.listStrokeRectValues.add(intArray);
        this.canvas.setListStrokeRectValues(this.listStrokeRectValues);
        this.canvas.setMethod(3);
    }

    @Override
    public void strokeText(String text, int x, int y) {
    }

    @Override
    public void strokeText(String text, int x, int y, int maxWidth) {
    }

    @Override
    public void transform(int m11, int m12, int m21, int m22, int dx, int dy) {
    }

    @Override
    public void translate(int tx, int ty) {
    }

    @Override
    public void addColorStop(String offset, String color) {
        int i;
        for (i = 0; i < this.fractions.length; ++i) {
            if (this.fractions[i] != 0.0f) continue;
            this.fractions[i] = new Float(offset).floatValue();
            break;
        }
        for (i = 0; i < this.colors.length; ++i) {
            if (this.colors[i] != null) continue;
            this.colors[i] = ColorFactory.getInstance().getColor(color);
            break;
        }
    }
}

