/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.w3c.DOMTokenList;

public class DOMTokenListImpl
implements DOMTokenList {
    private String itemValue;
    private HTMLElementImpl element;

    public DOMTokenListImpl(HTMLElementImpl element, String item) {
        this.element = element;
        this.itemValue = item;
    }

    @Override
    public int getLength() {
        if (this.itemValue != null) {
            return this.itemValue.split(" ").length;
        }
        return 0;
    }

    @Override
    public String item(int index) {
        if (this.itemValue != null) {
            String[] listString = this.itemValue.split(" ");
            for (int i = 0; i < listString.length; ++i) {
                if (index != i) continue;
                return listString[i];
            }
        }
        return null;
    }

    @Override
    public boolean contains(String token) {
        return this.itemValue.contains(token);
    }

    @Override
    public void add(String token) {
        if (this.element.getClassName() != null) {
            this.element.setClassName(this.element.getClassName() + " " + token);
        } else {
            this.element.setClassName(token);
        }
    }

    @Override
    public void remove(String token) {
        String[] listString = this.itemValue.split(" ");
        String result = "";
        for (int i = 0; i < listString.length; ++i) {
            String test = listString[i];
            if (test.equals(token)) continue;
            result = result + test;
        }
        this.element.setClassName(result);
    }

    @Override
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @Override
    public boolean toggle(String token, boolean force) {
        if (force) {
            this.add(token);
        } else {
            this.remove(token);
        }
        return force;
    }
}

