/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.awt.Image;
import java.util.ArrayList;
import org.lobobrowser.html.dombl.ImageEvent;
import org.lobobrowser.html.dombl.ImageListener;
import org.lobobrowser.html.dombl.UINode;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.js.Executor;
import org.lobobrowser.html.renderstate.ImageRenderState;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.w3c.HTMLImageElement;
import org.mozilla.javascript.Function;

public class HTMLImageElementImpl
extends HTMLAbstractUIElement
implements HTMLImageElement {
    private Image image = null;
    private String imageSrc;
    private Function onload;
    private final ArrayList<ImageListener> listeners = new ArrayList(1);

    public HTMLImageElementImpl() {
        super("IMG");
    }

    public HTMLImageElementImpl(String name) {
        super(name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public String getAlign() {
        return this.getAttribute("align");
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    @Override
    public String getAlt() {
        return this.getAttribute("alt");
    }

    @Override
    public void setAlt(String alt) {
        this.setAttribute("alt", alt);
    }

    @Override
    public String getBorder() {
        return this.getAttribute("border");
    }

    @Override
    public void setBorder(String border) {
        this.setAttribute("border", border);
    }

    @Override
    public int getHeight() {
        String height = this.getAttribute("height");
        UINode r = this.uiNode;
        if (height != null && height.length() > 0) {
            return new Integer(height);
        }
        return r == null ? 0 : r.getBounds().height;
    }

    @Override
    public void setHeight(int height) {
        this.setAttribute("height", String.valueOf(height));
    }

    @Override
    public int getHspace() {
        return this.getAttributeAsInt("hspace", 0);
    }

    @Override
    public void setHspace(int hspace) {
        this.setAttribute("hspace", String.valueOf(hspace));
    }

    @Override
    public boolean getIsMap() {
        return this.getAttributeAsBoolean("isMap");
    }

    @Override
    public void setIsMap(boolean isMap) {
        this.setAttribute("isMap", isMap ? "isMap" : null);
    }

    @Override
    public String getLongDesc() {
        return this.getAttribute("longdesc");
    }

    @Override
    public void setLongDesc(String longDesc) {
        this.setAttribute("longdesc", longDesc);
    }

    @Override
    public String getSrc() {
        return this.getAttribute("src");
    }

    @Override
    public void setSrc(String src) {
        this.setAttribute("src", src);
    }

    @Override
    public String getUseMap() {
        return this.getAttribute("useMap");
    }

    @Override
    public void setUseMap(String useMap) {
        this.setAttribute("useMap", useMap);
    }

    @Override
    public int getVspace() {
        return this.getAttributeAsInt("vspace", 0);
    }

    @Override
    public void setVspace(int vspace) {
        this.setAttribute("vspace", String.valueOf(vspace));
    }

    @Override
    public int getWidth() {
        String width = this.getAttribute("width");
        UINode r = this.uiNode;
        if (width != null && width.length() > 0) {
            return new Integer(width);
        }
        return r == null ? 0 : r.getBounds().width;
    }

    @Override
    public void setWidth(int width) {
        this.setAttribute("width", String.valueOf(width));
    }

    @Override
    protected void assignAttributeField(String normalName, String value) {
        super.assignAttributeField(normalName, value);
        if ("src".equals(normalName)) {
            this.loadImage(value);
        }
    }

    @Override
    public Function getOnload() {
        return this.getEventFunction(this.onload, "onload");
    }

    @Override
    public void setOnload(Function onload) {
        this.onload = onload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImage(String src) {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.document;
        if (document != null) {
            ArrayList<ImageListener> arrayList = this.listeners;
            synchronized (arrayList) {
                this.imageSrc = src;
                this.image = null;
            }
            if (src != null) {
                document.loadImage(src, new LocalImageListener(src));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Image getImage() {
        ArrayList<ImageListener> arrayList = this.listeners;
        synchronized (arrayList) {
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(ImageListener listener) {
        Image currentImage;
        ArrayList<ImageListener> l;
        ArrayList<ImageListener> arrayList = l = this.listeners;
        synchronized (arrayList) {
            currentImage = this.image;
            l.add(listener);
        }
        if (currentImage != null) {
            listener.imageLoaded(new ImageEvent(this, currentImage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(ImageListener listener) {
        ArrayList<ImageListener> l;
        ArrayList<ImageListener> arrayList = l = this.listeners;
        synchronized (arrayList) {
            l.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(String expectedImgSrc, ImageEvent event) {
        ImageListener[] listenerArray;
        ArrayList<ImageListener> l;
        ArrayList<ImageListener> arrayList = l = this.listeners;
        synchronized (arrayList) {
            if (!expectedImgSrc.equals(this.imageSrc)) {
                return;
            }
            this.image = event.image;
            listenerArray = l.toArray(ImageListener.EMPTY_ARRAY);
        }
        int llength = listenerArray.length;
        for (int i = 0; i < llength; ++i) {
            listenerArray[i].imageLoaded(event);
        }
        Function onload = this.getOnload();
        if (onload != null) {
            Executor.executeFunction(this, onload, null);
        }
    }

    @Override
    protected RenderState createRenderState(RenderState prevRenderState) {
        return new ImageRenderState(prevRenderState, this);
    }

    @Override
    public int getNaturalWidth() {
        return 0;
    }

    @Override
    public int getNaturalHeight() {
        return 0;
    }

    @Override
    public boolean getComplete() {
        return false;
    }

    private class LocalImageListener
    implements ImageListener {
        private final String expectedImgSrc;

        public LocalImageListener(String imgSrc) {
            this.expectedImgSrc = imgSrc;
        }

        @Override
        public void imageLoaded(ImageEvent event) {
            HTMLImageElementImpl.this.dispatchEvent(this.expectedImgSrc, event);
        }
    }
}

