/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.dombl.ModelNode;
import org.lobobrowser.html.domimpl.DOMNodeImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseRListElement;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderstate.RenderState;
import org.lobobrowser.html.style.ListStyle;

class RList
extends BaseRListElement {
    public RList(DOMNodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer, RCollection parent) {
        super(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer);
    }

    @Override
    protected void applyStyle(int availWidth, int availHeight) {
        super.applyStyle(availWidth, availHeight);
        ListStyle listStyle = this.listStyle;
        if (listStyle == null || listStyle.type == 256) {
            int listNesting;
            ModelNode rootNode = this.modelNode;
            if (!(rootNode instanceof HTMLElementImpl)) {
                return;
            }
            HTMLElementImpl rootElement = (HTMLElementImpl)rootNode;
            if (listStyle == null) {
                this.listStyle = listStyle = new ListStyle();
            }
            listStyle.type = "ul".equalsIgnoreCase(rootElement.getTagName()) ? ((listNesting = this.listNesting) == 0 ? 1 : (listNesting == 1 ? 2 : 3)) : 4;
        }
    }

    @Override
    public void doLayout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight, FloatingBoundsSource floatBoundsSource, int defaultOverflowX, int defaultOverflowY, boolean sizeOnly) {
        RenderState renderState = this.modelNode.getRenderState();
        int counterStart = 1;
        ModelNode rootNode = this.modelNode;
        if (!(rootNode instanceof HTMLElementImpl)) {
            return;
        }
        HTMLElementImpl rootElement = (HTMLElementImpl)rootNode;
        String startText = rootElement.getAttribute("start");
        if (startText != null) {
            try {
                counterStart = Integer.parseInt(startText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        renderState.resetCount("$cobra.counter", this.listNesting, counterStart);
        super.doLayout(availWidth, availHeight, expandWidth, expandHeight, floatBoundsSource, defaultOverflowX, defaultOverflowY, sizeOnly);
    }
}

