/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lobobrowser.http.Header;
import org.lobobrowser.http.Method;
import org.lobobrowser.http.Parameter;
import org.lobobrowser.http.XPathUtils;
import org.lobobrowser.util.AbstractBean;
import org.w3c.dom.Document;

public class Request
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(Request.class.getName());
    private Map<String, Header> headers = new HashMap<String, Header>();
    private Map<String, Parameter> params = new HashMap<String, Parameter>();
    private boolean followRedirects = true;
    private Method method = Method.GET;
    private String url;
    private InputStream requestBody;
    private String username;
    private char[] password;
    private String stringBody;

    public Request() {
        this(Method.GET, null);
    }

    public Request(String url) {
        this(Method.GET, url);
    }

    public Request(Method method, String url) {
        this.method = method == null ? Method.GET : method;
        this.setHeader("Accept-Encoding", "gzip");
        this.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (url != null) {
            this.setUrlImpl(url);
        }
    }

    public Request(Request source) {
        if (source != null) {
            this.username = source.username;
            this.password = source.password;
            this.headers.putAll(source.headers);
            this.params.putAll(source.params);
            this.followRedirects = source.followRedirects;
            this.method = source.method;
            this.url = source.url;
        }
    }

    public final Header getHeader(String name) {
        if (name == null) {
            return null;
        }
        return this.headers.get(name.toLowerCase());
    }

    public final void setHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.setHeader(new Header(name, value));
    }

    public final void setHeader(String name, String value, Header.Element ... elements) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.setHeader(new Header(name, value, elements));
    }

    public void setHeader(Header header) {
        if (header == null) {
            throw new IllegalArgumentException("header cannot be null");
        }
        if (header.getName() == null) {
            throw new IllegalArgumentException("header name cannot be null");
        }
        this.headers.put(header.getName().toLowerCase(), header);
        if ("Authentication".equals(header.getName())) {
            try {
                String encoded = header.getValue().substring(6);
                String tmp = Request.base64Decode(encoded);
                String u = tmp.substring(0, tmp.indexOf(":"));
                String p = tmp.substring(tmp.indexOf(":") + 1);
                String oldUsername = this.username;
                this.username = u;
                this.firePropertyChange("username", oldUsername, this.username);
                this.password = p.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void removeHeader(Header header) {
        if (header != null) {
            this.headers.remove(header.getName().toLowerCase());
        }
    }

    public final void removeHeader(String header) {
        this.headers.remove(header.toLowerCase());
    }

    public final Header[] getHeaders() {
        return this.headers.values().toArray(new Header[0]);
    }

    public final void setHeaders(Header ... headers) {
        this.headers.clear();
        if (headers != null) {
            for (Header h : headers) {
                this.setHeader(h);
            }
        }
    }

    public final Parameter getParameter(String name) {
        if (name == null) {
            return null;
        }
        return this.params.get(name);
    }

    public final void setParameter(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        this.setParameter(new Parameter(name, value));
    }

    public void setParameter(Parameter param) {
        if (param == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        if (param.getName() == null) {
            throw new IllegalArgumentException("parameter name cannot be null");
        }
        this.params.put(param.getName(), param);
    }

    public final Parameter[] getParameters() {
        return this.params.values().toArray(new Parameter[0]);
    }

    public final void setParameters(Parameter ... params) {
        this.params.clear();
        if (params != null) {
            for (Parameter p : params) {
                this.setParameter(p);
            }
        }
    }

    public void setFollowRedirects(boolean b) {
        boolean old = this.getFollowRedirects();
        this.followRedirects = b;
        this.firePropertyChange("followRedirects", old, this.followRedirects);
    }

    public final boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setMethod(Method method) {
        Method old = this.getMethod();
        this.method = method == null ? Method.GET : method;
        this.firePropertyChange("method", (Object)old, (Object)this.method);
    }

    public final Method getMethod() {
        return this.method;
    }

    public void setUrl(String url) throws IllegalArgumentException {
        String old = this.getUrl();
        this.setUrlImpl(url);
        this.firePropertyChange("url", old, this.url);
    }

    private void setUrlImpl(String url) {
        int index;
        this.url = url;
        if (url != null && (index = url.indexOf("?")) >= 0) {
            this.url = url.substring(0, index);
            String[] parts = url.substring(index + 1).split("&");
            try {
                for (String part : parts) {
                    String key = null;
                    String value = null;
                    index = part.indexOf("=");
                    if (index < 0) {
                        key = part;
                        key = URLDecoder.decode(key, "UTF-8");
                    } else {
                        key = part.substring(0, index);
                        value = part.substring(index + 1);
                        key = URLDecoder.decode(key, "UTF-8");
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    this.setParameter(key, value);
                }
            }
            catch (Exception e) {
                logger.severe(e.getMessage());
            }
        }
    }

    public final String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        String old = this.username;
        this.username = username;
        this.resetAuthenticationHeader();
        this.firePropertyChange("username", old, this.username);
    }

    private void resetAuthenticationHeader() {
        try {
            if (this.username == null) {
                this.removeHeader("authentication");
            } else {
                this.headers.put("authentication", new Header("Authentication", "Basic " + Request.base64Encode(this.username + ":" + this.getPassword())));
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    public final String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password == null ? new char[]{} : password.toCharArray();
        this.resetAuthenticationHeader();
    }

    final String getPassword() {
        return this.password == null ? "" : new String(this.password);
    }

    public void setBody(String body) {
        this.stringBody = body;
        this.setBody(body == null ? null : body.getBytes());
    }

    public void setBody(byte[] body) {
        if (body == null || body.length == 0) {
            this.requestBody = null;
        } else {
            this.setBody(new ByteArrayInputStream(body));
        }
    }

    public void setBody(Document body) {
        this.setBody(body == null ? null : XPathUtils.toXML(body));
    }

    public void setBody(InputStream body) {
        this.requestBody = body;
    }

    protected InputStream getBody() throws Exception {
        return this.requestBody;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append((Object)this.getMethod());
        buffer.append(" " + this.getUrl() + "\n");
        for (Header h : this.getHeaders()) {
            buffer.append("  ").append(h.getName()).append(": ").append(h.getValue());
            buffer.append("\n");
        }
        if (this.stringBody != null) {
            buffer.append(this.stringBody);
        } else {
            buffer.append("<<body content>>");
        }
        return buffer.toString();
    }

    private static String base64Encode(String s) throws Exception {
        return "";
    }

    private static String base64Decode(String s) throws Exception {
        return "";
    }
}

