/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaObjectWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaConstructorObject
extends ScriptableObject
implements Function {
    private static final long serialVersionUID = 1L;
    private final JavaClassWrapper classWrapper;
    private final JavaInstantiator instantiator;
    private final String name;

    public JavaConstructorObject(String name, JavaClassWrapper classWrapper) {
        this.name = name;
        this.classWrapper = classWrapper;
        this.instantiator = new SimpleInstantiator(classWrapper);
    }

    public JavaConstructorObject(String name, JavaClassWrapper classWrapper, JavaInstantiator instantiator) {
        this.name = name;
        this.classWrapper = classWrapper;
        this.instantiator = instantiator;
    }

    @Override
    public String getClassName() {
        return this.name;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        try {
            Object javaObject = this.instantiator.newInstance();
            JavaObjectWrapper newObject = new JavaObjectWrapper(this.classWrapper, javaObject);
            newObject.setParentScope(scope);
            return newObject;
        }
        catch (Exception err) {
            throw new IllegalStateException(err.getMessage());
        }
    }

    public Object getDefaultValue(Class hint) {
        if (String.class.equals((Object)hint)) {
            return "function " + this.name;
        }
        return super.getDefaultValue(hint);
    }

    public static class SimpleInstantiator
    implements JavaInstantiator {
        private final JavaClassWrapper classWrapper;

        public SimpleInstantiator(JavaClassWrapper classWrapper) {
            this.classWrapper = classWrapper;
        }

        @Override
        public Object newInstance() throws InstantiationException, IllegalAccessException {
            return this.classWrapper.newInstance();
        }
    }
}

