/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.main;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.EventObject;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.gui.DefaultWindowFactory;
import org.lobobrowser.gui.FramePanel;
import org.lobobrowser.main.ExtensionManager;
import org.lobobrowser.main.ReuseManager;
import org.lobobrowser.protocol.res.Handler;
import org.lobobrowser.settings.GeneralSettings;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.SimpleThreadPool;
import org.lobobrowser.util.SimpleThreadPoolTask;
import org.lobobrowser.util.Urls;

public class PlatformInit {
    private static final String NATIVE_DIR_NAME = "native";
    private final SimpleThreadPool threadExecutor = new SimpleThreadPool("MainThreadPool", 2, 10, 60000);
    private final GeneralSettings generalSettings = GeneralSettings.getInstance();
    private boolean windowHasBeenShown = false;
    private static final PlatformInit instance = new PlatformInit();
    private File applicationDirectory;

    private PlatformInit() {
    }

    public boolean isCodeLocationDirectory() {
        URL codeLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        return codeLocation != null && Urls.isLocalFile(codeLocation) && codeLocation.getPath().endsWith("/");
    }

    public void initExtensions() {
        ExtensionManager.getInstance().initExtensions();
    }

    public void init() throws Exception {
        this.initExtensions();
    }

    public void launch(String urlOrPath) throws MalformedURLException {
        URL url = Urls.guessURL(urlOrPath);
        FramePanel.openWindow(null, url, null, new Properties(), "GET", null);
    }

    public void launch() throws MalformedURLException {
        String[] startupURLs;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Logger logger = Logger.getLogger(PlatformInit.class.getName());
            logger.warning("launch(): Security manager not set!");
        }
        for (String url : startupURLs = this.generalSettings.getStartupURLs()) {
            this.launch(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) throws MalformedURLException {
        DefaultWindowFactory.getInstance().evtWindowShown.addListener(new GenericEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processEvent(EventObject event) {
                PlatformInit platformInit = PlatformInit.this;
                synchronized (platformInit) {
                    PlatformInit.this.windowHasBeenShown = true;
                    PlatformInit.this.notifyAll();
                }
            }
        });
        boolean launched = false;
        for (String url : args) {
            if (url.startsWith("-")) continue;
            try {
                launched = true;
                this.launch(url);
            }
            catch (Exception err) {
                err.printStackTrace(System.err);
            }
        }
        if (!launched) {
            this.launch();
        }
        PlatformInit platformInit = this;
        synchronized (platformInit) {
            while (!this.windowHasBeenShown) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static PlatformInit getInstance() {
        return instance;
    }

    public static void shutdown() {
        try {
            ReuseManager.getInstance().shutdown();
        }
        catch (Exception err) {
            err.printStackTrace(System.err);
        }
        System.exit(0);
    }

    public void scheduleTask(SimpleThreadPoolTask task) {
        this.threadExecutor.schedule(task);
    }

    public File getApplicationDirectory() {
        File appDir = this.applicationDirectory;
        if (appDir == null) {
            File jarFile;
            ProtectionDomain pd = this.getClass().getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            URL url = cs.getLocation();
            if (url == null) {
                this.applicationDirectory = new File("");
                return this.applicationDirectory;
            }
            String jarPath = url.getPath();
            try {
                jarFile = new File(url.toURI());
            }
            catch (URISyntaxException use) {
                throw new IllegalStateException(use);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalStateException("Application code source apparently not a local JAR file: " + url + ". Only local JAR files are supported at the moment.", iae);
            }
            File installDir = jarFile.getParentFile();
            if (installDir == null) {
                throw new IllegalStateException("Installation directory is missing. Startup JAR path is " + jarPath + ".");
            }
            if (!installDir.exists()) {
                throw new IllegalStateException("Installation directory not found. Startup JAR path is " + jarPath + ". Directory path is " + installDir.getAbsolutePath() + ".");
            }
            this.applicationDirectory = appDir = installDir;
            Logger logger = Logger.getLogger(this.getClass().getName());
            if (logger.isLoggable(Level.INFO)) {
                logger.info("getApplicationDirectory(): url=" + url + ",appDir=" + appDir);
            }
        }
        return appDir;
    }

    private static class LocalStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private LocalStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if (protocol.equals("res")) {
                return new Handler();
            }
            if (protocol.equals("vc")) {
                return new org.lobobrowser.protocol.vc.Handler();
            }
            return null;
        }
    }
}

