/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import org.lobobrowser.primary.ext.ActionPool;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.primary.settings.ToolsSettings;
import org.lobobrowser.ua.NavigatorWindow;
import org.lobobrowser.ua.RequestType;

public class OpenFileAction
extends ActionPool {
    private static final long serialVersionUID = 1L;
    private ComponentSource componentSource;
    private NavigatorWindow window;

    public OpenFileAction(ComponentSource componentSource, NavigatorWindow window) {
        super(componentSource, window);
        this.componentSource = componentSource;
        this.window = window;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnValue;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        ToolsSettings settings = ToolsSettings.getInstance();
        File directory = settings.getOpenFileDirectory();
        if (directory != null) {
            fileChooser.setSelectedFile(directory);
        }
        if ((returnValue = fileChooser.showOpenDialog(this.window.getTopFrame().getComponent())) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            this.componentSource.navigate(selectedFile.toURI().toString(), RequestType.PROGRAMMATIC);
            settings.setOpenFileDirectory(selectedFile);
            settings.save();
        }
    }
}

