/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.Component;
import java.awt.Insets;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.primary.clientlets.html.HtmlRendererContextImpl;
import org.lobobrowser.ua.NavigatorFrame;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.TargetType;
import org.w3c.dom.Document;

public class BrowserFrameImpl
implements BrowserFrame {
    private static final Logger logger = Logger.getLogger(BrowserFrameImpl.class.getName());
    private final NavigatorFrame frame;
    private final HtmlRendererContextImpl rcontext;

    public BrowserFrameImpl(NavigatorFrame frame, HtmlRendererContext parentrcontext) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("BrowserFrameImpl(): frame=" + frame + ",parentrcontext=" + parentrcontext);
        }
        this.frame = frame;
        this.rcontext = HtmlRendererContextImpl.getHtmlRendererContext(frame);
    }

    @Override
    public HtmlRendererContext getHtmlRendererContext() {
        return this.rcontext;
    }

    @Override
    public Component getComponent() {
        return this.frame.getComponent();
    }

    @Override
    public Document getContentDocument() {
        return this.rcontext.getContentDocument();
    }

    @Override
    public void loadURL(URL url) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("loadURL(): frame=" + this.frame + ",url=" + url);
        }
        this.frame.navigate(url, "GET", null, TargetType.SELF, RequestType.FRAME);
    }

    @Override
    public void setDefaultMarginInsets(Insets insets) {
        this.frame.setProperty("defaultMarginInsets", insets);
    }

    @Override
    public void setDefaultOverflowX(int overflowX) {
        this.frame.setProperty("defaultOverflowX", overflowX);
    }

    @Override
    public void setDefaultOverflowY(int overflowY) {
        this.frame.setProperty("defaultOverflowY", overflowY);
    }
}

