/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.clientlets.html;

import java.awt.Image;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.lobobrowser.context.NetworkRequestImpl;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.http.Header;
import org.lobobrowser.ua.NetworkRequest;
import org.lobobrowser.ua.NetworkRequestEvent;
import org.lobobrowser.ua.NetworkRequestListener;
import org.w3c.dom.Document;

public class HttpRequestImpl
implements HttpRequest {
    private NetworkRequest networkRequest;
    private HttpURLConnection connection = null;

    public HttpRequestImpl(NetworkRequest networkRequest) {
        this.networkRequest = networkRequest;
    }

    @Override
    public void abort() {
        this.networkRequest.abort();
    }

    @Override
    public String getAllResponseHeaders() {
        return this.networkRequest.getAllResponseHeaders();
    }

    @Override
    public int getReadyState() {
        return this.networkRequest.getReadyState();
    }

    @Override
    public byte[] getResponseBytes() {
        return this.networkRequest.getResponseBytes();
    }

    @Override
    public String getResponseHeader(String headerName) {
        return this.networkRequest.getResponseHeader(headerName);
    }

    @Override
    public Image getResponseImage() {
        return this.networkRequest.getResponseImage();
    }

    @Override
    public String getResponseText() {
        return this.networkRequest.getResponseText();
    }

    @Override
    public Document getResponseXML() {
        return this.networkRequest.getResponseXML();
    }

    @Override
    public int getStatus() {
        return this.networkRequest.getStatus();
    }

    @Override
    public String getStatusText() {
        return this.networkRequest.getStatusText();
    }

    @Override
    public void open(String method, String url, boolean asyncFlag) throws IOException {
        this.networkRequest.open(method, url, asyncFlag);
    }

    @Override
    public void open(String method, String url) throws IOException {
        this.networkRequest.open(method, url);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName, String password) throws IOException {
        this.networkRequest.open(method, url, asyncFlag, userName, password);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag, String userName) throws IOException {
        this.networkRequest.open(method, url, asyncFlag, userName);
    }

    @Override
    public void open(String method, URL url, boolean asyncFlag) throws IOException {
        this.networkRequest.open(method, url, asyncFlag);
    }

    @Override
    public void open(String method, URL url) throws IOException {
        this.networkRequest.open(method, url);
    }

    @Override
    public void send(String content) throws IOException {
        this.networkRequest.send(content);
    }

    @Override
    public void addReadyStateChangeListener(final ReadyStateChangeListener listener) {
        this.networkRequest.addNetworkRequestListener(new NetworkRequestListener(){

            @Override
            public void readyStateChanged(NetworkRequestEvent event) {
                listener.readyStateChanged();
            }
        });
    }

    @Override
    public void setRequestHeader(String header, String value) {
        NetworkRequestImpl nr = new NetworkRequestImpl();
        if (this.getReadyState() != 1) {
            throw new IllegalStateException("The AsyncHttpRequest must be opened prior to setting a request header");
        }
        if (header == null || value == null) {
            throw new IllegalArgumentException("Neither the header, nor value, may be null");
        }
        if (header.equalsIgnoreCase("Accept-Charset") || header.equalsIgnoreCase("Accept-Encoding") || header.equalsIgnoreCase("Content-Length") || header.equalsIgnoreCase("Expect") || header.equalsIgnoreCase("Date") || header.equalsIgnoreCase("Host") || header.equalsIgnoreCase("Keep-Alive") || header.equalsIgnoreCase("Referer") || header.equalsIgnoreCase("TE") || header.equalsIgnoreCase("Trailer") || header.equalsIgnoreCase("Transfer-Encoding") || header.equalsIgnoreCase("Upgrade")) {
            return;
        }
        if (header.equalsIgnoreCase("Authorization") || header.equalsIgnoreCase("Content-Base") || header.equalsIgnoreCase("Content-Location") || header.equalsIgnoreCase("Content-MD5") || header.equalsIgnoreCase("Content-Range") || header.equalsIgnoreCase("Content-Type") || header.equalsIgnoreCase("Content-Version") || header.equalsIgnoreCase("Delta-Base") || header.equalsIgnoreCase("Depth") || header.equalsIgnoreCase("Destination") || header.equalsIgnoreCase("ETag") || header.equalsIgnoreCase("Expect") || header.equalsIgnoreCase("From") || header.equalsIgnoreCase("If-Modified-Since") || header.equalsIgnoreCase("If-Range") || header.equalsIgnoreCase("If-Unmodified-Since") || header.equalsIgnoreCase("Max-Forwards") || header.equalsIgnoreCase("MIME-Version") || header.equalsIgnoreCase("Overwrite") || header.equalsIgnoreCase("Proxy-Authorization") || header.equalsIgnoreCase("SOAPAction") || header.equalsIgnoreCase("Timeout")) {
            for (Header h : nr.getReq().getHeaders()) {
                if (!h.getName().equalsIgnoreCase(header)) continue;
                nr.getReq().removeHeader(h);
                nr.getReq().setHeader(new Header(header, value));
                break;
            }
        } else {
            boolean appended = false;
            for (Header h : nr.getReq().getHeaders()) {
                if (!h.getName().equalsIgnoreCase(header)) continue;
                nr.getReq().removeHeader(h);
                nr.getReq().setHeader(new Header(header, h.getValue() + ", " + value));
                appended = true;
                break;
            }
            if (!appended) {
                nr.getReq().setHeader(new Header(header, value));
            }
        }
    }
}

