/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.lobobrowser.primary.ext.ComponentSource;
import org.lobobrowser.primary.ext.TextFieldComboBoxEditor;

public class AddressField
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private final ComponentSource componentSource;
    private boolean comboInvalid = true;
    private boolean comboHasHeadMatches = false;
    private boolean populatingMatches = false;

    public AddressField(ComponentSource cs) {
        this.componentSource = cs;
        this.setEditable(true);
        TextFieldComboBoxEditor editor = new TextFieldComboBoxEditor();
        this.setEditor(editor);
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AddressField.this.onKeyReleased(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AddressField.this.onKeyPressed(e);
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AddressField.this.onBeforePopupVisible();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if ("comboBoxEdited".equals(cmd)) {
                    AddressField.this.onEdited(event.getModifiers());
                } else if ("comboBoxChanged".equals(cmd)) {
                    // empty if block
                }
            }
        });
        this.onBeforePopupVisible();
    }

    public String getText() {
        if (this.isEditable()) {
            return (String)this.getEditor().getItem();
        }
        return String.valueOf(this.getSelectedItem());
    }

    public void setText(String text) {
        AddressField combo = this;
        boolean editable = this.isEditable();
        if (editable) {
            combo.getEditor().setItem(text);
        }
    }

    public void setUrl(URL url) {
        this.setText(url == null ? "" : url.toExternalForm());
    }

    private void onBeforePopupVisible() {
        if ((this.comboInvalid || this.comboHasHeadMatches) && !this.populatingMatches) {
            this.populateCombo(this.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCombo(String comboBoxText) {
        this.populatingMatches = true;
        try {
            AddressField urlComboBox = this;
            urlComboBox.removeAllItems();
            Collection<String> recentUrls = this.componentSource.getRecentLocations(30);
            for (String matchUrl : recentUrls) {
                urlComboBox.addItem(matchUrl);
            }
            this.setText(comboBoxText);
            this.comboHasHeadMatches = false;
            this.comboInvalid = false;
        }
        finally {
            this.populatingMatches = false;
        }
    }

    private void onEdited(int modifiers) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onKeyReleased(KeyEvent event) {
        AddressField urlComboBox = this;
        char releasedChar = event.getKeyChar();
        if (this.validPopupChar(releasedChar)) {
            String urlText = urlComboBox.getText();
            Collection<String> headMatches = this.componentSource.getPotentialMatches(urlText, 30);
            if (headMatches.size() == 0) {
                if (urlComboBox.isPopupVisible()) {
                    urlComboBox.hidePopup();
                }
            } else {
                this.populatingMatches = true;
                try {
                    urlComboBox.removeAllItems();
                    for (String matchUrl : headMatches) {
                        urlComboBox.addItem(matchUrl);
                    }
                    this.comboHasHeadMatches = true;
                    if (!urlComboBox.isPopupVisible()) {
                        urlComboBox.showPopup();
                    }
                    urlComboBox.setSelectedItem(null);
                    urlComboBox.setText(urlText);
                }
                finally {
                    this.populatingMatches = false;
                }
            }
        }
    }

    private void onKeyPressed(KeyEvent event) {
        String urlText;
        AddressField urlComboBox = this;
        if (event.getKeyCode() == 10 && (urlText = urlComboBox.getText()).length() != 0) {
            this.componentSource.navigateOrSearch();
        }
    }

    private boolean validPopupChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '.' || ch == '/';
    }
}

