/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.ext;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.lobobrowser.primary.ext.HistoryEntry;
import org.lobobrowser.primary.ext.HostEntry;

public abstract class BaseHistory<T>
implements Serializable {
    private static final long serialVersionUID = 2257845020000200400L;
    private final SortedSet<String> historySortedSet = new TreeSet<String>();
    private final Map<String, TimedEntry> historyMap = new HashMap<String, TimedEntry>();
    private final SortedSet<TimedEntry> historyTimedSet = new TreeSet<TimedEntry>();
    private final int commonEntriesCapacity = 1000;

    protected BaseHistory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRecentEntries() {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            return this.historyTimedSet.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getRecentItems(int maxNumItems) {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            LinkedList<String> items = new LinkedList<String>();
            Iterator i = this.historyTimedSet.iterator();
            int count = 0;
            while (i.hasNext() && count++ < maxNumItems) {
                TimedEntry entry = (TimedEntry)i.next();
                items.add(entry.value);
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> getRecentItemInfo(int maxNumItems) {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            LinkedList<Object> items = new LinkedList<Object>();
            Iterator i = this.historyTimedSet.iterator();
            int count = 0;
            while (i.hasNext() && count++ < maxNumItems) {
                TimedEntry entry = (TimedEntry)i.next();
                items.add(entry.itemInfo);
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HostEntry> getRecentHostEntries(int maxNumItems) {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            LinkedList<HostEntry> items = new LinkedList<HostEntry>();
            Iterator i = this.historyTimedSet.iterator();
            HashSet<String> hosts = new HashSet<String>();
            while (i.hasNext()) {
                TimedEntry entry = (TimedEntry)i.next();
                String host = entry.url.getHost();
                if (host == null || host.length() == 0 || hosts.contains(host)) continue;
                hosts.add(host);
                if (hosts.size() >= maxNumItems) break;
                items.add(new HostEntry(host, entry.timestamp));
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoryEntry<T>> getAllEntries() {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            LinkedList<HistoryEntry<T>> items = new LinkedList<HistoryEntry<T>>();
            for (TimedEntry entry : this.historyTimedSet) {
                items.add(new HistoryEntry<Object>(entry.url, entry.timestamp, entry.itemInfo));
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<HistoryEntry<T>> getRecentEntries(int maxNumItems) {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            LinkedList<HistoryEntry<T>> items = new LinkedList<HistoryEntry<T>>();
            for (TimedEntry entry : this.historyTimedSet) {
                if (items.size() >= maxNumItems) break;
                items.add(new HistoryEntry<Object>(entry.url, entry.timestamp, entry.itemInfo));
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getHeadMatchItems(String itemPrefix, int maxNumItems) {
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            String potentialItem;
            Object[] array = this.historySortedSet.toArray();
            int idx = Arrays.binarySearch(array, itemPrefix);
            int startIdx = idx >= 0 ? idx : -idx - 1;
            int count = 0;
            LinkedList<String> items = new LinkedList<String>();
            for (int i = startIdx; i < array.length && count++ < maxNumItems && (potentialItem = (String)array[i]).startsWith(itemPrefix); ++i) {
                items.add(potentialItem);
            }
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAsRecent(URL url, T itemInfo) {
        String item = url.toExternalForm();
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            TimedEntry entry = this.historyMap.get(item);
            if (entry != null) {
                this.historyTimedSet.remove(entry);
                entry.touch();
                entry.itemInfo = itemInfo;
                this.historyTimedSet.add(entry);
            } else {
                entry = new TimedEntry(url, item, itemInfo);
                this.historyTimedSet.add(entry);
                this.historyMap.put(item, entry);
                this.historySortedSet.add(item);
                while (this.historyTimedSet.size() > this.commonEntriesCapacity) {
                    TimedEntry entryToRemove = this.historyTimedSet.last();
                    this.historyMap.remove(entryToRemove.value);
                    this.historySortedSet.remove(entryToRemove.value);
                    this.historyTimedSet.remove(entryToRemove);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(URL url) {
        String item = url.toExternalForm();
        BaseHistory baseHistory = this;
        synchronized (baseHistory) {
            TimedEntry entry = this.historyMap.get(item);
            if (entry != null) {
                this.historyTimedSet.remove(entry);
                entry.touch();
                this.historyTimedSet.add(entry);
            }
        }
    }

    public T getExistingInfo(String item) {
        TimedEntry entry = this.historyMap.get(item);
        return (T)(entry == null ? null : entry.itemInfo);
    }

    private class TimedEntry
    implements Comparable<Object>,
    Serializable {
        private static final long serialVersionUID = 2257845000000000200L;
        private long timestamp = System.currentTimeMillis();
        private final URL url;
        private final String value;
        private T itemInfo;

        public TimedEntry(URL url, String textValue, T itemInfo) {
            this.itemInfo = itemInfo;
            this.value = textValue;
            this.url = url;
        }

        public void touch() {
            this.timestamp = System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            TimedEntry other = (TimedEntry)obj;
            return other.value.equals(this.value);
        }

        @Override
        public int compareTo(Object arg0) {
            if (this.equals(arg0)) {
                return 0;
            }
            TimedEntry other = (TimedEntry)arg0;
            long time1 = this.timestamp;
            long time2 = other.timestamp;
            if (time1 > time2) {
                return -1;
            }
            if (time2 > time1) {
                return 1;
            }
            return this.value.compareTo(other.value);
        }
    }
}

