/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.pdf;

import com.sun.pdfview.Flag;
import com.sun.pdfview.FullScreenWindow;
import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFDestination;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFPrintPage;
import com.sun.pdfview.PageChangeListener;
import com.sun.pdfview.PagePanel;
import com.sun.pdfview.ThumbPanel;
import com.sun.pdfview.action.GoToAction;
import com.sun.pdfview.action.PDFAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import org.lobobrowser.http.SSLCertificate;

public class PdfDialog
extends JFrame
implements KeyListener,
TreeSelectionListener,
PageChangeListener {
    private static final Logger logger = Logger.getLogger(PdfDialog.class.getName());
    private static final long serialVersionUID = 1L;
    public static final String TITLE = "SwingLabs PDF Viewer";
    PDFFile curFile;
    String docName;
    JSplitPane split;
    JScrollPane thumbscroll;
    ThumbPanel thumbs;
    PagePanel page;
    PagePanel fspp;
    int curpage = -1;
    JToggleButton fullScreenButton;
    JTextField pageField;
    FullScreenWindow fullScreen;
    OutlineNode outline = null;
    PageFormat pformat = PrinterJob.getPrinterJob().defaultPage();
    boolean doThumb = true;
    Flag docWaiter;
    PagePreparer pagePrep;
    JDialog olf;
    JMenu docMenu;
    Action pageSetupAction = new AbstractAction("Page setup..."){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doPageSetup();
        }
    };
    Action printAction = new AbstractAction("Print...", this.getIcon("/toolbarButtonGraphics/general/Print16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doPrint();
        }
    };
    Action closeAction = new AbstractAction("Close"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doClose();
        }
    };
    Action quitAction = new AbstractAction("Quit"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doQuit();
        }
    };
    Action zoomToolAction = new AbstractAction("", this.getIcon("/toolbarButtonGraphics/general/ZoomIn16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doZoomTool();
        }
    };
    Action fitInWindowAction = new AbstractAction("Fit in window", this.getIcon("/toolbarButtonGraphics/general/ZoomOut16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doFitInWindow();
        }
    };
    ThumbAction thumbAction = new ThumbAction();
    Action fullScreenAction = new AbstractAction("Full screen", this.getIcon("/toolbarButtonGraphics/media/Play16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doFullScreen((evt.getModifiers() & 1) != 0);
        }
    };
    Action nextAction = new AbstractAction("Next", this.getIcon("/toolbarButtonGraphics/navigation/Forward16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doNext();
        }
    };
    Action prevAction = new AbstractAction("Prev", this.getIcon("/toolbarButtonGraphics/navigation/Back16.gif")){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doPrev();
        }
    };
    FileFilter pdfFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".pdf");
        }

        @Override
        public String getDescription() {
            return "Choose a PDF file";
        }
    };
    private File prevDirChoice;
    PageBuilder pb = new PageBuilder();

    public Icon getIcon(String name) {
        ImageIcon icon = null;
        URL url = null;
        try {
            url = this.getClass().getResource(name);
            icon = new ImageIcon(url);
        }
        catch (Exception e) {
            System.out.println("Couldn't find " + this.getClass().getName() + "/" + name);
            logger.severe(e.getMessage());
        }
        return icon;
    }

    public PdfDialog(boolean useThumbs) {
        super(TITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PdfDialog.this.doQuit();
            }
        });
        this.doThumb = useThumbs;
        this.init();
    }

    protected void init() {
        this.page = new PagePanel();
        this.page.addKeyListener((KeyListener)this);
        if (this.doThumb) {
            this.split = new JSplitPane(1);
            this.split.addPropertyChangeListener("dividerLocation", this.thumbAction);
            this.split.setOneTouchExpandable(true);
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll = new JScrollPane((Component)this.thumbs, 22, 31);
            this.split.setLeftComponent(this.thumbscroll);
            this.split.setRightComponent((Component)this.page);
            this.getContentPane().add((Component)this.split, "Center");
        } else {
            this.getContentPane().add((Component)this.page, "Center");
        }
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton jb = new JButton(this.prevAction);
        jb.setText("");
        toolbar.add(jb);
        this.pageField = new JTextField("-", 3);
        this.pageField.setMaximumSize(new Dimension(45, 32));
        this.pageField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PdfDialog.this.doPageTyped();
            }
        });
        toolbar.add(this.pageField);
        jb = new JButton(this.nextAction);
        jb.setText("");
        toolbar.add(jb);
        toolbar.add(Box.createHorizontalGlue());
        this.fullScreenButton = new JToggleButton(this.fullScreenAction);
        this.fullScreenButton.setText("");
        toolbar.add(this.fullScreenButton);
        this.fullScreenButton.setEnabled(true);
        toolbar.add(Box.createHorizontalGlue());
        ButtonGroup bg = new ButtonGroup();
        JToggleButton jtb = new JToggleButton(this.zoomToolAction);
        jtb.setText("");
        bg.add(jtb);
        toolbar.add(jtb);
        jtb = new JToggleButton(this.fitInWindowAction);
        jtb.setText("");
        bg.add(jtb);
        jtb.setSelected(true);
        toolbar.add(jtb);
        toolbar.add(Box.createHorizontalGlue());
        jb = new JButton(this.printAction);
        jb.setText("");
        toolbar.add(jb);
        this.getContentPane().add((Component)toolbar, "North");
        JMenuBar mb = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(this.closeAction);
        file.addSeparator();
        file.add(this.pageSetupAction);
        file.add(this.printAction);
        file.addSeparator();
        file.add(this.quitAction);
        mb.add(file);
        this.setJMenuBar(mb);
        this.setEnabling();
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - this.getWidth()) / 2;
        int y = (screen.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (SwingUtilities.isEventDispatchThread()) {
            this.show();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PdfDialog.this.show();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void gotoPage(int pagenum) {
        if (pagenum < 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.forceGotoPage(pagenum);
    }

    public void forceGotoPage(int pagenum) {
        if (pagenum <= 0) {
            pagenum = 0;
        } else if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        this.curpage = pagenum;
        this.pageField.setText(String.valueOf(this.curpage + 1));
        PDFPage pg = this.curFile.getPage(pagenum + 1);
        if (this.fspp != null) {
            this.fspp.showPage(pg);
            this.fspp.requestFocus();
        } else {
            this.page.showPage(pg);
            this.page.requestFocus();
        }
        if (this.doThumb) {
            this.thumbs.pageShown(pagenum);
        }
        if (this.pagePrep != null) {
            this.pagePrep.quit();
        }
        this.pagePrep = new PagePreparer(pagenum);
        this.pagePrep.start();
        this.setEnabling();
    }

    public void setEnabling() {
        boolean fileavailable;
        boolean bl = fileavailable = this.curFile != null;
        boolean pageshown = this.fspp != null ? this.fspp.getPage() != null : this.page.getPage() != null;
        boolean printable = fileavailable && this.curFile.isPrintable();
        this.pageField.setEnabled(fileavailable);
        this.printAction.setEnabled(printable);
        this.closeAction.setEnabled(fileavailable);
        this.fullScreenAction.setEnabled(pageshown);
        this.prevAction.setEnabled(pageshown);
        this.nextAction.setEnabled(pageshown);
        this.zoomToolAction.setEnabled(pageshown);
        this.fitInWindowAction.setEnabled(pageshown);
    }

    public void openFile(URL url) throws IOException {
        SSLCertificate.setCertificate();
        URLConnection urlConnection = url.openConnection();
        int contentLength = urlConnection.getContentLength();
        InputStream istr = urlConnection.getInputStream();
        byte[] byteBuf = new byte[contentLength];
        int offset = 0;
        int read = 0;
        while (read >= 0) {
            read = istr.read(byteBuf, offset, contentLength - offset);
            if (read <= 0) continue;
            offset += read;
        }
        if (offset != contentLength) {
            throw new IOException("Could not read all of URL file.");
        }
        ByteBuffer buf = ByteBuffer.allocate(contentLength);
        buf.put(byteBuf);
        this.openPDFByteBuffer(buf, url.toString(), url.getFile());
    }

    public void openFile(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel channel = raf.getChannel();
        MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
        this.openPDFByteBuffer(buf, file.getPath(), file.getName());
        raf.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileUnMapped(File file) throws IOException {
        FilterInputStream istr = null;
        try {
            istr = new DataInputStream(new FileInputStream(file));
            long len = file.length();
            if (len > Integer.MAX_VALUE) {
                throw new IOException("File too long to decode: " + file.getName());
            }
            int contentLength = (int)len;
            byte[] byteBuf = new byte[contentLength];
            int offset = 0;
            int read = 0;
            while (read >= 0) {
                read = ((DataInputStream)istr).read(byteBuf, offset, contentLength - offset);
                if (read <= 0) continue;
                offset += read;
            }
            ByteBuffer buf = ByteBuffer.allocate(contentLength);
            buf.put(byteBuf);
            this.openPDFByteBuffer(buf, file.getPath(), file.getName());
        }
        catch (FileNotFoundException e) {
            logger.severe(e.getMessage());
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        finally {
            if (istr != null) {
                try {
                    istr.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void openPDFByteBuffer(ByteBuffer buf, String path, String name) {
        PDFFile newfile = null;
        try {
            newfile = new PDFFile(buf);
        }
        catch (IOException ioe) {
            this.openError(path + " doesn't appear to be a PDF file.");
            return;
        }
        this.doClose();
        this.curFile = newfile;
        this.docName = name;
        this.setTitle("SwingLabs PDF Viewer: " + this.docName);
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(this.curFile);
            this.thumbs.addPageChangeListener((PageChangeListener)this);
            this.thumbscroll.getViewport().setView((Component)this.thumbs);
            this.thumbscroll.getViewport().setBackground(Color.gray);
        }
        this.setEnabling();
        this.forceGotoPage(0);
        try {
            this.outline = this.curFile.getOutline();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.outline != null) {
            if (this.outline.getChildCount() > 0) {
                this.olf = new JDialog((Frame)this, "Outline");
                this.olf.setDefaultCloseOperation(0);
                this.olf.setLocation(this.getLocation());
                JTree jt = new JTree((TreeNode)this.outline);
                jt.setRootVisible(false);
                jt.addTreeSelectionListener(this);
                JScrollPane jsp = new JScrollPane(jt);
                this.olf.getContentPane().add(jsp);
                this.olf.pack();
                this.olf.setVisible(true);
            } else if (this.olf != null) {
                this.olf.setVisible(false);
                this.olf = null;
            }
        }
    }

    public void openError(String message) {
        JOptionPane.showMessageDialog(this.split, message, "Error opening file", 0);
    }

    public void doOpen() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(this.prevDirChoice);
            fc.setFileFilter(this.pdfFilter);
            fc.setMultiSelectionEnabled(false);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.prevDirChoice = fc.getSelectedFile();
                    this.openFile(fc.getSelectedFile());
                }
                catch (IOException e) {
                    logger.severe(e.getMessage());
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.split, "Opening files from your local disk is not available\nfrom the Java Web Start version of this program.\n", "Error opening directory", 0);
            logger.severe(e.getMessage());
        }
    }

    public void doOpen(String name) {
        try {
            this.openFile(new URL(name));
        }
        catch (IOException ioe) {
            try {
                this.openFile(new File(name));
            }
            catch (IOException ex) {
                Logger.getLogger(PdfDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void doPageSetup() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        this.pformat = pjob.pageDialog(this.pformat);
    }

    public void doPrint() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        pjob.setJobName(this.docName);
        Book book = new Book();
        PDFPrintPage pages = new PDFPrintPage(this.curFile);
        book.append((Printable)pages, this.pformat, this.curFile.getNumPages());
        pjob.setPageable(book);
        if (pjob.printDialog()) {
            new PrintThread(pages, pjob).start();
        }
    }

    public void doClose() {
        if (this.thumbs != null) {
            this.thumbs.stop();
        }
        if (this.olf != null) {
            this.olf.setVisible(false);
            this.olf = null;
        }
        if (this.doThumb) {
            this.thumbs = new ThumbPanel(null);
            this.thumbscroll.getViewport().setView((Component)this.thumbs);
        }
        this.setFullScreenMode(false, false);
        this.page.showPage(null);
        this.curFile = null;
        this.setTitle(TITLE);
        this.setEnabling();
    }

    public void doQuit() {
        this.doClose();
        this.dispose();
    }

    public void doZoomTool() {
        if (this.fspp == null) {
            this.page.useZoomTool(true);
        }
    }

    public void doFitInWindow() {
        if (this.fspp == null) {
            this.page.useZoomTool(false);
            this.page.setClip(null);
        }
    }

    public void doThumbs(boolean show) {
        if (show) {
            this.split.setDividerLocation(this.thumbs.getPreferredSize().width + this.thumbscroll.getVerticalScrollBar().getWidth() + 4);
        } else {
            this.split.setDividerLocation(0);
        }
    }

    public void doFullScreen(boolean force) {
        this.setFullScreenMode(this.fullScreen == null, force);
    }

    public void doZoom(double factor) {
    }

    public void doNext() {
        this.gotoPage(this.curpage + 1);
    }

    public void doPrev() {
        this.gotoPage(this.curpage - 1);
    }

    public void doFirst() {
        this.gotoPage(0);
    }

    public void doLast() {
        this.gotoPage(this.curFile.getNumPages() - 1);
    }

    public void doPageTyped() {
        int pagenum = -1;
        try {
            pagenum = Integer.parseInt(this.pageField.getText()) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (pagenum >= this.curFile.getNumPages()) {
            pagenum = this.curFile.getNumPages() - 1;
        }
        if (pagenum >= 0) {
            if (pagenum != this.curpage) {
                this.gotoPage(pagenum);
            }
        } else {
            this.pageField.setText(String.valueOf(this.curpage));
        }
    }

    public void setFullScreenMode(boolean full, boolean force) {
        if (full && this.fullScreen == null) {
            this.fullScreenAction.setEnabled(false);
            new Thread((Runnable)new PerformFullScreenMode(force), this.getClass().getName() + ".setFullScreenMode").start();
            this.fullScreenButton.setSelected(true);
        } else if (!full && this.fullScreen != null) {
            this.fullScreen.close();
            this.fspp = null;
            this.fullScreen = null;
            this.gotoPage(this.curpage);
            this.fullScreenButton.setSelected(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 37) {
            this.doPrev();
        } else if (code == 39) {
            this.doNext();
        } else if (code == 38) {
            this.doPrev();
        } else if (code == 40) {
            this.doNext();
        } else if (code == 36) {
            this.doFirst();
        } else if (code == 35) {
            this.doLast();
        } else if (code == 33) {
            this.doPrev();
        } else if (code == 34) {
            this.doNext();
        } else if (code == 32) {
            this.doNext();
        } else if (code == 27) {
            this.setFullScreenMode(false, false);
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        if (key >= '0' && key <= '9') {
            int val = key - 48;
            this.pb.keyTyped(val);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.isAddedPath()) {
            OutlineNode node = (OutlineNode)e.getPath().getLastPathComponent();
            if (node == null) {
                return;
            }
            try {
                PDFAction action = node.getAction();
                if (action == null) {
                    return;
                }
                if (action instanceof GoToAction) {
                    PDFDestination dest = ((GoToAction)action).getDestination();
                    if (dest == null) {
                        return;
                    }
                    PDFObject page = dest.getPage();
                    if (page == null) {
                        return;
                    }
                    int pageNum = this.curFile.getPageNumber(page);
                    if (pageNum >= 0) {
                        this.gotoPage(pageNum);
                    }
                }
            }
            catch (IOException ioe) {
                logger.severe(ioe.getMessage());
            }
        }
    }

    class PageBuilder
    implements Runnable {
        int value = 0;
        long timeout;
        Thread anim;
        static final long TIMEOUT = 500L;

        PageBuilder() {
        }

        public synchronized void keyTyped(int keyval) {
            this.value = this.value * 10 + keyval;
            this.timeout = System.currentTimeMillis() + 500L;
            if (this.anim == null) {
                this.anim = new Thread(this);
                this.anim.setName(this.getClass().getName());
                this.anim.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long then;
            long now;
            PageBuilder pageBuilder = this;
            synchronized (pageBuilder) {
                now = System.currentTimeMillis();
                then = this.timeout;
            }
            while (now < then) {
                try {
                    Thread.sleep(this.timeout - now);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                pageBuilder = this;
                synchronized (pageBuilder) {
                    now = System.currentTimeMillis();
                    then = this.timeout;
                }
            }
            pageBuilder = this;
            synchronized (pageBuilder) {
                PdfDialog.this.gotoPage(this.value - 1);
                this.anim = null;
                this.value = 0;
            }
        }
    }

    class PerformFullScreenMode
    implements Runnable {
        boolean force;

        public PerformFullScreenMode(boolean forcechoice) {
            this.force = forcechoice;
        }

        @Override
        public void run() {
            PdfDialog.this.fspp = new PagePanel();
            PdfDialog.this.fspp.setBackground(Color.black);
            PdfDialog.this.page.showPage(null);
            PdfDialog.this.fullScreen = new FullScreenWindow((JComponent)PdfDialog.this.fspp, this.force);
            PdfDialog.this.fspp.addKeyListener((KeyListener)PdfDialog.this);
            PdfDialog.this.gotoPage(PdfDialog.this.curpage);
            PdfDialog.this.fullScreenAction.setEnabled(true);
        }
    }

    class PrintThread
    extends Thread {
        PDFPrintPage ptPages;
        PrinterJob ptPjob;

        public PrintThread(PDFPrintPage pages, PrinterJob pjob) {
            this.ptPages = pages;
            this.ptPjob = pjob;
            this.setName(this.getClass().getName());
        }

        @Override
        public void run() {
            try {
                this.ptPages.show(this.ptPjob);
                this.ptPjob.print();
            }
            catch (PrinterException pe) {
                JOptionPane.showMessageDialog(PdfDialog.this, "Printing Error: " + pe.getMessage(), "Print Aborted", 0);
            }
            this.ptPages.hide();
        }
    }

    class PagePreparer
    extends Thread {
        int waitforPage;
        int prepPage;

        public PagePreparer(int waitforPage) {
            this.setDaemon(true);
            this.setName(this.getClass().getName());
            this.waitforPage = waitforPage;
            this.prepPage = waitforPage + 1;
        }

        public void quit() {
            this.waitforPage = -1;
        }

        @Override
        public void run() {
            PDFPage pdfPage;
            Dimension size = null;
            Rectangle2D clip = null;
            if (PdfDialog.this.fspp != null) {
                PdfDialog.this.fspp.waitForCurrentPage();
                size = PdfDialog.this.fspp.getCurSize();
                clip = PdfDialog.this.fspp.getCurClip();
            } else if (PdfDialog.this.page != null) {
                PdfDialog.this.page.waitForCurrentPage();
                size = PdfDialog.this.page.getCurSize();
                clip = PdfDialog.this.page.getCurClip();
            }
            if (this.waitforPage == PdfDialog.this.curpage && (pdfPage = PdfDialog.this.curFile.getPage(this.prepPage + 1, true)) != null && this.waitforPage == PdfDialog.this.curpage) {
                pdfPage.getImage(size.width, size.height, clip, null, true, true);
            }
        }
    }

    class ThumbAction
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        boolean isOpen;

        public ThumbAction() {
            super("Hide thumbnails");
            this.isOpen = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int v = (Integer)evt.getNewValue();
            if (v <= 1) {
                this.isOpen = false;
                this.putValue("ActionCommandKey", "Show thumbnails");
                this.putValue("Name", "Show thumbnails");
            } else {
                this.isOpen = true;
                this.putValue("ActionCommandKey", "Hide thumbnails");
                this.putValue("Name", "Hide thumbnails");
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PdfDialog.this.doThumbs(!this.isOpen);
        }
    }
}

