/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.request.FileWithHeadersURLConnection;
import org.lobobrowser.request.MemoryCacheEntry;
import org.lobobrowser.request.MemoryURLConnection;
import org.lobobrowser.store.CacheManager;
import org.lobobrowser.store.ClassLoaderObjectInputStream;
import org.lobobrowser.util.Urls;

public class CacheInfo {
    private static final Logger logger = Logger.getLogger(CacheInfo.class.getName());
    static final String HEADER_REQUEST_TIME = "X-Request-Time";
    private final URL url;
    private final MemoryCacheEntry memoryEntry;
    private final byte[] persistentContent;
    private URLConnection connection;

    public CacheInfo(MemoryCacheEntry memEntry, byte[] persContent, URL url) {
        this.persistentContent = persContent;
        this.url = url;
        this.memoryEntry = memEntry;
    }

    public final URLConnection getURLConnection() {
        if (this.connection == null) {
            MemoryCacheEntry memEntry = this.memoryEntry;
            if (memEntry != null) {
                this.connection = new MemoryURLConnection(this.url, memEntry);
            } else {
                byte[] content = this.persistentContent;
                if (content == null) {
                    throw new IllegalStateException("Memory entry and persistent content unavailable.");
                }
                this.connection = new FileWithHeadersURLConnection(this.url, content);
            }
        }
        return this.connection;
    }

    public final void dispose() {
        URLConnection connection = this.connection;
        if (connection instanceof FileWithHeadersURLConnection) {
            ((FileWithHeadersURLConnection)connection).disconnect();
        }
    }

    public final boolean isCacheConnection(URLConnection connection) {
        return connection == this.getURLConnection();
    }

    public final String getDateAsText() {
        return this.getURLConnection().getHeaderField("date");
    }

    public final Long getExpiresGivenOffset(long offsetSeconds) {
        MemoryCacheEntry entry = this.memoryEntry;
        if (entry != null) {
            return entry.requestTime + offsetSeconds * 1000L;
        }
        String rtText = this.getURLConnection().getHeaderField(HEADER_REQUEST_TIME);
        if (rtText == null) {
            return null;
        }
        long rt = Long.parseLong(rtText);
        return rt + offsetSeconds * 1000L;
    }

    public final Long getExpires() {
        MemoryCacheEntry entry = this.memoryEntry;
        if (entry != null) {
            return entry.expiration;
        }
        URLConnection connection = this.getURLConnection();
        String requestTimeText = connection.getHeaderField(HEADER_REQUEST_TIME);
        if (requestTimeText == null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("getExpires(): Cached content does not have X-Request-Time header: " + this.url + ".");
            }
            return new Long(0L);
        }
        long requestTime = Long.parseLong(requestTimeText);
        return Urls.getExpiration(connection, requestTime);
    }

    public long getRequestTime() {
        MemoryCacheEntry entry = this.memoryEntry;
        if (entry != null) {
            return entry.requestTime;
        }
        URLConnection connection = this.getURLConnection();
        String requestTimeText = connection.getHeaderField(HEADER_REQUEST_TIME);
        if (requestTimeText == null) {
            return 0L;
        }
        return Long.parseLong(requestTimeText);
    }

    public boolean hasTransientEntry() {
        return this.memoryEntry != null;
    }

    public Object getTransientObject() {
        MemoryCacheEntry memEntry = this.memoryEntry;
        return memEntry != null ? memEntry.altObject : null;
    }

    public int getTransientObjectSize() {
        MemoryCacheEntry memEntry = this.memoryEntry;
        return memEntry != null ? memEntry.altObjectSize : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPersistentObject(ClassLoader classLoader) {
        Object object;
        byte[] content = CacheManager.getInstance().getPersistent(this.url, true);
        if (content == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        ClassLoaderObjectInputStream oin = new ClassLoaderObjectInputStream(in, classLoader);
        try {
            object = oin.readObject();
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "getPersistentObject(): Unable to load persistent cached object.", ioe);
                return null;
            }
            catch (ClassNotFoundException ioe) {
                logger.log(Level.WARNING, "getPersistentObject(): Failed to load persistent cached object apparently due to versioning issue.", ioe);
                return null;
            }
        }
        oin.close();
        ((InputStream)in).close();
        return object;
    }

    public void delete() {
        CacheManager cm = CacheManager.getInstance();
        cm.removeTransient(this.url);
        try {
            cm.removePersistent(this.url, false);
            cm.removePersistent(this.url, true);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "delete()", ioe);
        }
    }

    public byte[] getPersistentContent() {
        return this.persistentContent;
    }
}

