/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.http.SSLCertificate;
import org.lobobrowser.request.CacheInfo;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.util.GenericEventListener;
import org.lobobrowser.util.InputProgressEvent;
import org.lobobrowser.util.MonitoredInputStream;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.io.BufferExceededException;
import org.lobobrowser.util.io.RecordedInputStream;

public class ClientletResponseImpl
implements ClientletResponse {
    private static final Logger logger = Logger.getLogger(ClientletResponseImpl.class.getName());
    private static final int MAX_CACHE_BUFFER_SIZE = 0xA00000;
    private final URLConnection connection;
    private final RequestHandler requestHandler;
    private final boolean isCacheable;
    private final CacheInfo cacheInfo;
    private final boolean fromCache;
    private final RequestType requestType;
    private final URL responseURL;
    private InputStream inputStream;
    private Serializable newPeristentCachedObject;
    private Object newTransientCachedObject;
    private int newTransientObjectSize;

    public ClientletResponseImpl(RequestHandler rhandler, URLConnection connection, URL responseURL, boolean fromCache, CacheInfo cacheInfo, boolean isCacheable, RequestType requestType) {
        this.connection = connection;
        this.responseURL = responseURL;
        this.requestHandler = rhandler;
        this.isCacheable = isCacheable;
        this.cacheInfo = cacheInfo;
        this.fromCache = fromCache;
        this.requestType = requestType;
    }

    public ClientletResponseImpl(RequestHandler rhandler, URL url, boolean fromCache, CacheInfo cacheInfo, boolean isCacheable, String requestMethod, RequestType requestType) throws IOException {
        SSLCertificate.setCertificate();
        this.connection = url.openConnection();
        this.responseURL = url;
        this.requestHandler = rhandler;
        this.isCacheable = isCacheable;
        this.cacheInfo = cacheInfo;
        this.fromCache = fromCache;
        this.requestType = requestType;
    }

    @Override
    public boolean isNewNavigationAction() {
        RequestType rt = this.requestType;
        return rt != RequestType.HISTORY && rt != RequestType.SOFT_RELOAD && rt != RequestType.HARD_RELOAD;
    }

    @Override
    public boolean matches(String mimeType, String[] fileExtensions) {
        String responseMimeType = this.getMimeType();
        if (responseMimeType == null || "application/octet-stream".equalsIgnoreCase(responseMimeType) || "content/unknown".equalsIgnoreCase(responseMimeType)) {
            String path = this.responseURL.getPath();
            if (path == null) {
                return false;
            }
            String pathTL = path.toLowerCase();
            for (int i = 0; i < fileExtensions.length; ++i) {
                String fileExtensionTL = fileExtensions[i].toLowerCase();
                if (!fileExtensionTL.startsWith(".")) {
                    fileExtensionTL = "." + fileExtensionTL;
                }
                if (!pathTL.endsWith(fileExtensionTL)) continue;
                return true;
            }
            return false;
        }
        return responseMimeType.equalsIgnoreCase(mimeType);
    }

    @Override
    public String getLastRequestMethod() {
        return this.requestHandler.getLatestRequestMethod();
    }

    public void handleProgress(ProgressType progressType, URL url, String method, int value, int max) {
        this.requestHandler.handleProgress(progressType, url, method, value, max);
    }

    @Override
    public boolean isFromCache() {
        return this.fromCache;
    }

    @Override
    public boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    public URL getResponseURL() {
        return this.responseURL;
    }

    @Override
    public String getHeader(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public String[] getHeaders(String name) {
        Map<String, List<String>> headers = this.connection.getHeaderFields();
        List<String> valuesList = headers.get(name);
        return valuesList == null ? null : valuesList.toArray(new String[0]);
    }

    @Override
    public Iterator getHeaderNames() {
        Map<String, List<String>> headers = this.connection.getHeaderFields();
        return headers.keySet().iterator();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            BufferedInputStream bis;
            int contentLength;
            InputStream in;
            URLConnection connection = this.connection;
            if (connection instanceof HttpURLConnection) {
                in = ((HttpURLConnection)connection).getErrorStream();
                if (in == null) {
                    in = connection.getInputStream();
                }
            } else {
                in = connection.getInputStream();
            }
            int bufferSize = (contentLength = connection.getContentLength()) <= 0 ? 4096 : Math.min(contentLength, 8192);
            final URL responseURL = this.getResponseURL();
            if (this.requestHandler != null) {
                MonitoredInputStream mis = new MonitoredInputStream(in);
                mis.evtProgress.addListener(new GenericEventListener(){

                    @Override
                    public void processEvent(EventObject event) {
                        InputProgressEvent pe = (InputProgressEvent)event;
                        ClientletResponseImpl.this.requestHandler.handleProgress(ProgressType.CONTENT_LOADING, responseURL, ClientletResponseImpl.this.getLastRequestMethod(), pe.getProgress(), contentLength);
                    }
                });
                bis = new BufferedInputStream(mis, bufferSize);
            } else {
                bis = new BufferedInputStream(in, bufferSize);
            }
            this.inputStream = this.isCacheable ? new RecordedInputStream(bis, 0xA00000) : bis;
        }
        return this.inputStream;
    }

    @Override
    public String getContentType() {
        return this.connection.getContentType();
    }

    @Override
    public String getMimeType() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        int scIdx = contentType.indexOf(59);
        return scIdx == -1 ? contentType.trim() : contentType.substring(0, scIdx).trim();
    }

    @Override
    public int getContentLength() {
        return this.connection.getContentLength();
    }

    public void ensureReachedEOF() throws IOException {
        RecordedInputStream rin;
        InputStream in = this.getInputStream();
        if (in instanceof RecordedInputStream && !(rin = (RecordedInputStream)in).hasReachedEOF()) {
            rin.consumeToEOF();
        }
    }

    public byte[] getStoredContent() {
        RecordedInputStream rin;
        InputStream in = this.inputStream;
        if (in instanceof RecordedInputStream && (rin = (RecordedInputStream)in).hasReachedEOF()) {
            try {
                return rin.getBytesRead();
            }
            catch (BufferExceededException bee) {
                logger.warning("getStoredContent(): Recorded stream buffer size exceeded.");
                return null;
            }
        }
        return null;
    }

    private String getDefaultCharset() {
        URL url = this.getResponseURL();
        if (Urls.isLocalFile(url)) {
            String charset = System.getProperty("file.encoding");
            return charset == null ? "ISO-8859-1" : charset;
        }
        return "ISO-8859-1";
    }

    @Override
    public String getCharset() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return this.getDefaultCharset();
        }
        StringTokenizer tok = new StringTokenizer(contentType, ";");
        if (tok.hasMoreTokens()) {
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String varName;
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx == -1 || !"charset".equalsIgnoreCase(varName = assignment.substring(0, eqIdx).trim())) continue;
                String varValue = assignment.substring(eqIdx + 1);
                return Strings.unquote(varValue.trim());
            }
        }
        return this.getDefaultCharset();
    }

    @Override
    public boolean isCharsetProvided() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(contentType, ";");
        if (tok.hasMoreTokens()) {
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String varName;
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx == -1 || !"charset".equalsIgnoreCase(varName = assignment.substring(0, eqIdx).trim())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseCode();
        }
        return 0;
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseMessage();
        }
        return "";
    }

    public String toString() {
        return "ClientletResponseImpl[url=" + this.responseURL + ",method=" + this.getLastRequestMethod() + ",mimeType=" + this.getMimeType() + ",fromCache=" + this.isFromCache() + ",requestType=" + (Object)((Object)this.requestType) + "]";
    }

    @Override
    public Object getPersistentCachedObject(ClassLoader classLoader) {
        CacheInfo cacheInfo = this.cacheInfo;
        return cacheInfo == null ? null : cacheInfo.getPersistentObject(classLoader);
    }

    @Override
    public Object getTransientCachedObject() {
        CacheInfo cacheInfo = this.cacheInfo;
        return cacheInfo == null ? null : cacheInfo.getTransientObject();
    }

    @Override
    public int getTransientCachedObjectSize() {
        CacheInfo cacheInfo = this.cacheInfo;
        return cacheInfo == null ? null : Integer.valueOf(cacheInfo.getTransientObjectSize());
    }

    @Override
    public void setNewPersistentCachedObject(Serializable object) {
        this.newPeristentCachedObject = object;
    }

    @Override
    public void setNewTransientCachedObject(Object object, int approxSize) {
        this.newTransientCachedObject = object;
        this.newTransientObjectSize = approxSize;
    }

    public Serializable getNewPersistentCachedObject() {
        return this.newPeristentCachedObject;
    }

    public Object getNewTransientCachedObject() {
        return this.newTransientCachedObject;
    }

    public int getNewTransientObjectSize() {
        return this.newTransientObjectSize;
    }

    @Override
    public Date getDate() {
        String dateText = this.connection.getHeaderField("Date");
        if (dateText == null) {
            return null;
        }
        try {
            return Urls.PATTERN_RFC1123.parse(dateText);
        }
        catch (ParseException pe) {
            logger.warning("getDate(): Bad date '" + dateText + "' from " + this.getResponseURL() + ".");
            return null;
        }
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }
}

