/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.lobobrowser.clientlet.ClientletException;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.clientlet.ClientletResponse;
import org.lobobrowser.request.ClientletRequestImpl;
import org.lobobrowser.request.RequestHandler;
import org.lobobrowser.request.VerifiedHostsStore;
import org.lobobrowser.ua.ProgressType;
import org.lobobrowser.ua.RequestType;

public abstract class SimpleRequestHandler
implements RequestHandler {
    private static final Logger logger = Logger.getLogger(SimpleRequestHandler.class.getName());
    private final ClientletRequest request;
    private final RequestType requestType;
    private volatile boolean cancelled;

    public SimpleRequestHandler(boolean forNewWindow, URL url, RequestType requestType) {
        this.requestType = requestType;
        this.request = new ClientletRequestImpl(forNewWindow, url, requestType);
    }

    public SimpleRequestHandler(URL url, RequestType requestType) {
        this.requestType = requestType;
        this.request = new ClientletRequestImpl(url, requestType);
    }

    public SimpleRequestHandler(URL url, String method, String altPostData, RequestType requestType) {
        this.requestType = requestType;
        this.request = new ClientletRequestImpl(url, method, altPostData, requestType);
    }

    public boolean isNewNavigationEntry() {
        return false;
    }

    public String getCacheFileSuffix() {
        return null;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return new LocalHostnameVerifier();
    }

    @Override
    public String getLatestRequestMethod() {
        return this.request.getMethod();
    }

    @Override
    public URL getLatestRequestURL() {
        return this.request.getRequestURL();
    }

    @Override
    public ClientletRequest getRequest() {
        return this.request;
    }

    @Override
    public void handleProgress(ProgressType progressType, URL url, String method, int value, int max) {
    }

    @Override
    public boolean handleException(ClientletResponse response, Throwable exception) throws ClientletException {
        logger.log(Level.WARNING, "handleException(): Error processing response=[" + response + "]", exception);
        return true;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    private class LocalHostnameVerifier
    implements HostnameVerifier {
        private LocalHostnameVerifier() {
        }

        @Override
        public boolean verify(String host, SSLSession arg1) {
            VerifiedHostsStore vhs = VerifiedHostsStore.getInstance();
            return vhs.contains(host);
        }
    }
}

