/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import org.lobobrowser.security.LocalSecurityPolicy;

public class TempFileManager {
    private static TempFileManager instance;
    private static final String GENERAL_PREFIX = "LOBO-";
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_MONTH = 2592000000L;
    private static final long THIRTY_YEARS = 946080000000L;
    private static final String FILE_PREFIX;
    private final File TEMP_DIRECTORY;
    private final ReferenceQueue<JarFile> REFERENCE_QUEUE = new ReferenceQueue();
    private final Map<String, LocalWeakReference> wrByPath = new HashMap<String, LocalWeakReference>();
    private int counter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TempFileManager getInstance() {
        if (instance != null) return instance;
        Class<TempFileManager> clazz = TempFileManager.class;
        synchronized (TempFileManager.class) {
            if (instance != null) return instance;
            instance = new TempFileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TempFileManager() {
        File[] files;
        File tempDirectory;
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        this.TEMP_DIRECTORY = tempDirectory = new File(LocalSecurityPolicy.STORE_DIRECTORY, "tmp");
        if (!tempDirectory.exists()) {
            tempDirectory.mkdirs();
        }
        if ((files = tempDirectory.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (!name.startsWith(GENERAL_PREFIX) || name.startsWith(FILE_PREFIX) || files[i].lastModified() >= System.currentTimeMillis() - 2592000000L) continue;
                files[i].delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownCleanup() {
        File[] files = this.TEMP_DIRECTORY.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    File file = files[i];
                    String name = file.getName();
                    if (!name.startsWith(FILE_PREFIX)) continue;
                    String canonical = file.getCanonicalPath();
                    TempFileManager tempFileManager = this;
                    synchronized (tempFileManager) {
                        LocalWeakReference wr = this.wrByPath.get(canonical);
                        JarFile jarFile = (JarFile)wr.get();
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    file.delete();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarFile createJarFile(byte[] bytes) throws IOException {
        Reference<JarFile> ref;
        while ((ref = this.REFERENCE_QUEUE.poll()) != null) {
            String canonical = ((LocalWeakReference)ref).canonicalPath;
            new File(canonical).delete();
            TempFileManager tempFileManager = this;
            synchronized (tempFileManager) {
                this.wrByPath.remove(canonical);
            }
        }
        File file = this.newTempFile();
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(bytes);
        }
        finally {
            ((OutputStream)out).close();
        }
        JarFile jarFile = new JarFile(file);
        String canonical = file.getCanonicalPath();
        LocalWeakReference wr = new LocalWeakReference(jarFile, this.REFERENCE_QUEUE, canonical);
        TempFileManager tempFileManager = this;
        synchronized (tempFileManager) {
            this.wrByPath.put(canonical, wr);
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File newTempFile() throws IOException {
        TempFileManager tempFileManager = this;
        synchronized (tempFileManager) {
            int newCounter = this.counter++;
            File file = new File(this.TEMP_DIRECTORY, FILE_PREFIX + newCounter);
            return file;
        }
    }

    static {
        FILE_PREFIX = GENERAL_PREFIX + (System.currentTimeMillis() - 946080000000L) / 1000L + "-";
    }

    private class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            TempFileManager.this.shutdownCleanup();
        }
    }

    private static class LocalWeakReference
    extends WeakReference<JarFile> {
        public final String canonicalPath;

        public LocalWeakReference(JarFile referent, ReferenceQueue<? super JarFile> q, String canonicalPath) {
            super(referent, q);
            this.canonicalPath = canonicalPath;
        }
    }
}

