/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssFileType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.BrowserSet;
import com.jetbrains.quirksmode.CssHtmlPatternUtil;
import com.jetbrains.quirksmode.HtmlFilePattern;
import com.jetbrains.quirksmode.ProblemDetector;
import com.jetbrains.quirksmode.QuirksModeRegistrar;
import com.jetbrains.quirksmode.QuirksModeSettingsPanel;
import com.jetbrains.quirksmode.SupportedBrowsersBean;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuirksModeInspectionTool
extends LocalInspectionTool {
    private static final Key<ProcessingContext> CONTEXT_KEY = Key.create((String)"quirks.context");
    private static final List<ProblemDetector> ourDetectors = new ArrayList<ProblemDetector>();
    private final SupportedBrowsersBean mySupportedBrowsersBean = new SupportedBrowsersBean();

    @Nullable
    public JComponent createOptionsPanel() {
        return new QuirksModeSettingsPanel(this.mySupportedBrowsersBean);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "readSettings"));
        }
        this.mySupportedBrowsersBean.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "writeSettings"));
        }
        this.mySupportedBrowsersBean.writeSettings(node);
    }

    SupportedBrowsersBean getSupportedBrowsersBean() {
        return this.mySupportedBrowsersBean;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "buildVisitor"));
        }
        PsiFile file = holder.getFile();
        Language type = file.getLanguage();
        if (type != StdFileTypes.HTML.getLanguage() && type != StdFileTypes.XHTML.getLanguage() && type != StdFileTypes.JSP.getLanguage() && type != StdFileTypes.JSPX.getLanguage() && type != CssFileType.INSTANCE.getLanguage()) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                BrowserSet browserSet;
                ProcessingContext matchingContext = (ProcessingContext)session.getUserData(CONTEXT_KEY);
                if (matchingContext == null) {
                    matchingContext = new ProcessingContext();
                    PsiFile file = element.getContainingFile();
                    CssHtmlPatternUtil.buildCaches((PsiElement)file, matchingContext.getSharedContext());
                    browserSet = QuirksModeInspectionTool.this.getSupportedBrowsersBean().getBrowserSet();
                    matchingContext.getSharedContext().put(HtmlFilePattern.ACTIVE_BROWSERS_KEY, (Object)browserSet);
                    session.putUserData(CONTEXT_KEY, (Object)matchingContext);
                } else {
                    browserSet = (BrowserSet)matchingContext.getSharedContext().get(HtmlFilePattern.ACTIVE_BROWSERS_KEY);
                }
                ArrayList<ProblemDetector> activeDetectors = new ArrayList<ProblemDetector>();
                for (ProblemDetector detector : ourDetectors) {
                    if (!detector.isActive(browserSet)) continue;
                    activeDetectors.add(detector);
                }
                for (ProblemDetector detector : activeDetectors) {
                    if (!detector.getPattern().accepts((Object)element, matchingContext)) continue;
                    detector.createDescriptors(element, holder, browserSet, isOnTheFly);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    static void register(@NotNull ProblemDetector detector) {
        if (detector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detector", "com/jetbrains/quirksmode/QuirksModeInspectionTool", "register"));
        }
        ourDetectors.add(detector);
    }

    static {
        QuirksModeRegistrar.register();
    }
}

