/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ws.references.DelegatingClassReferenceThatReferencesAnyMethod;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CxfXmlReferenceProvider
extends MyReferenceProvider {
    @NonNls
    public static final String NS = "http://cxf.apache.org/jaxws";
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();
    @NonNls
    private static final String IMPLEMENTOR_ATTR_NAME = "implementor";
    @NonNls
    private static final String WSDL_LOCATION_ATTR_NAME = "wsdlLocation";
    private final MyReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(true);

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new NamespaceFilter(new String[]{NS}), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{IMPLEMENTOR_ATTR_NAME, WSDL_LOCATION_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/CxfXmlReferenceProvider", "getReferencesByElement"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute) {
            if (IMPLEMENTOR_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && element instanceof XmlAttributeValue) {
                XmlAttributeValue value = (XmlAttributeValue)element;
                if (value.getValue() != null && value.getValue().startsWith("#")) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlReferenceProvider", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] references = this.myClassProvider.getReferencesByElement(element);
                if (references.length > 0) {
                    PsiReference[] psiReferenceArray = CxfXmlReferenceProvider.updateLastClassRefWithAnyMemberRef(references);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlReferenceProvider", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
            }
            PsiReference[] psiReferenceArray = this.myPathProvider.getReferencesByElement(element);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/CxfXmlReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static PsiReference[] updateLastClassRefWithAnyMemberRef(PsiReference[] references) {
        PsiReference[] result = new PsiReference[references.length];
        System.arraycopy(references, 0, result, 0, references.length);
        references = result;
        references[references.length - 1] = new DelegatingClassReferenceThatReferencesAnyMethod(references[references.length - 1]);
        return references;
    }
}

