/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.ws.references.MyReferenceProvider;
import com.intellij.ws.utils.WsReferenceProvidersHelper;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JBossWSXmlReferenceProvider
extends MyReferenceProvider {
    private final MyReferenceProvider myClassProvider = WsReferenceProvidersHelper.acquireClassReferenceProvider();
    private final MyReferenceProvider myPathProvider = WsReferenceProvidersHelper.getInstance().acquirePathReferenceProvider(false);
    @NonNls
    public static final String HTTP_WWW_JBOSS_ORG_JBOSSWS_TOOLS = "http://www.jboss.org/jbossws-tools";
    @NonNls
    private static final String ENDPOINT_ATTR_NAME = "endpoint";
    @NonNls
    private static final String FILE_ATTR_NAME = "file";

    @Override
    public ElementFilter getAttributeFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new TextFilter("service", "mapping"), (ElementFilter)new NamespaceFilter(new String[]{HTTP_WWW_JBOSS_ORG_JBOSSWS_TOOLS})), 2);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ENDPOINT_ATTR_NAME, FILE_ATTR_NAME};
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/references/JBossWSXmlReferenceProvider", "getReferencesByElement"));
        }
        String name = ((XmlAttribute)element.getParent()).getName();
        if (FILE_ATTR_NAME.equals(name)) {
            PsiReference[] psiReferenceArray = this.myPathProvider != null ? this.myPathProvider.getReferencesByElement(element) : PsiReference.EMPTY_ARRAY;
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JBossWSXmlReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.myClassProvider.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/references/JBossWSXmlReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

