/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils;

import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.CommonReferenceProviderTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizingReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.ws.references.MyPathReferenceProvider;
import com.intellij.ws.references.MyReferenceProvider;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WsReferenceProvidersHelper {
    private MyPsiReferenceProvider myStaticPathReferenceProvider;
    private MyPathReferenceProvider myDynamicPathReferenceProvider;
    private static final ProcessingContext context = new ProcessingContext();
    private static final WsReferenceProvidersHelper instance = new WsReferenceProvidersHelper();

    public static WsReferenceProvidersHelper getInstance() {
        return instance;
    }

    private WsReferenceProvidersHelper() {
    }

    public MyPathReferenceProvider acquirePathReferenceProvider(boolean relativeFromWebRoot) {
        if (this.myStaticPathReferenceProvider == null) {
            this.myStaticPathReferenceProvider = new MyPsiReferenceProvider();
        }
        MyPathReferenceProvider result = this.myStaticPathReferenceProvider;
        if (relativeFromWebRoot) {
            result = new MyCustomizingReferenceProvider();
            ((MyCustomizingReferenceProvider)result).addCustomization((CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>>)FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Function<PsiFile, Collection<PsiFileSystemItem>>)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return result;
    }

    public MyPathReferenceProvider acquireDynamicPathReferenceProvider() {
        if (this.myDynamicPathReferenceProvider == null) {
            this.myDynamicPathReferenceProvider = new MyPathReferenceProvider(){
                final PathReferenceManager myPathReferenceManager = PathReferenceManager.getInstance();

                @Override
                @NotNull
                public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement) {
                    if (psiElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$1", "getReferencesByElement"));
                    }
                    PsiReference[] psiReferenceArray = this.myPathReferenceManager.createReferences(psiElement, false, false, false, new PathReferenceProvider[0]);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }

                @Override
                @NotNull
                public PsiReference[] getReferencesByString(String s, @NotNull PsiElement psiElement, int i) {
                    if (psiElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$1", "getReferencesByString"));
                    }
                    PsiReference[] psiReferenceArray = this.getReferencesByElement(psiElement);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$1", "getReferencesByString"));
                    }
                    return psiReferenceArray;
                }
            };
        }
        return this.myDynamicPathReferenceProvider;
    }

    public static MyReferenceProvider acquireClassReferenceProvider() {
        return new PsiReferenceProviderWrapper(CommonReferenceProviderTypes.getInstance().getClassReferenceProvider());
    }

    public static class PsiReferenceProviderWrapper
    extends MyReferenceProvider {
        final PsiReferenceProvider provider;

        public PsiReferenceProviderWrapper(PsiReferenceProvider provider) {
            this.provider = provider;
        }

        @Override
        public PsiReference[] getReferencesByElement(PsiElement psiElement) {
            return this.provider.getReferencesByElement(psiElement, context);
        }
    }

    private class MyCustomizingReferenceProvider
    extends MyPathReferenceProvider {
        private final CustomizingReferenceProvider myWrappedProvider;

        public MyCustomizingReferenceProvider() {
            this.myWrappedProvider = new CustomizingReferenceProvider((CustomizableReferenceProvider)WsReferenceProvidersHelper.this.myStaticPathReferenceProvider.myWrappedCustomizableProvider);
        }

        @Override
        public PsiReference[] getReferencesByElement(PsiElement psiElement) {
            return this.myWrappedProvider.getReferencesByElement(psiElement, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
            PsiReference[] psiReferenceArray;
            block4: {
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyCustomizingReferenceProvider", "getReferencesByString"));
                }
                WsReferenceProvidersHelper.this.myStaticPathReferenceProvider.myWrappedCustomizableProvider.setOptions(this.myWrappedProvider.getOptions());
                psiReferenceArray = WsReferenceProvidersHelper.this.myStaticPathReferenceProvider.myWrappedCustomizableProvider.getReferencesByString(str, position, offsetInPosition);
                if (psiReferenceArray != null) break block4;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyCustomizingReferenceProvider", "getReferencesByString"));
            }
            return psiReferenceArray;
            finally {
                WsReferenceProvidersHelper.this.myStaticPathReferenceProvider.myWrappedCustomizableProvider.setOptions(this.myWrappedProvider.getOptions());
            }
        }

        public void addCustomization(CustomizableReferenceProvider.CustomizationKey<Function<PsiFile, Collection<PsiFileSystemItem>>> defaultPathEvaluatorOption, Function<PsiFile, Collection<PsiFileSystemItem>> absoluteTopLevel) {
            this.myWrappedProvider.addCustomization(defaultPathEvaluatorOption, absoluteTopLevel);
        }
    }

    private static class MyPsiReferenceProvider
    extends MyPathReferenceProvider {
        private final MyCustomizableReferenceProvider myWrappedCustomizableProvider = new MyCustomizableReferenceProvider();

        MyPsiReferenceProvider() {
        }

        @Override
        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = this.myWrappedCustomizableProvider.getReferencesByElement(psiElement, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }

        @Override
        @NotNull
        public PsiReference[] getReferencesByString(String s, @NotNull PsiElement psiElement, int i) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider", "getReferencesByString"));
            }
            PsiReference[] psiReferenceArray = this.myWrappedCustomizableProvider.getReferencesByString(s, psiElement, i);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider", "getReferencesByString"));
            }
            return psiReferenceArray;
        }

        private static class MyCustomizableReferenceProvider
        extends PsiReferenceProvider
        implements CustomizableReferenceProvider {
            public Map<CustomizableReferenceProvider.CustomizationKey, Object> myCustomizationOptions;

            private MyCustomizableReferenceProvider() {
            }

            public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> customizationKeyObjectMap) {
                this.myCustomizationOptions = customizationKeyObjectMap;
            }

            @Nullable
            public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
                return this.myCustomizationOptions;
            }

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider$MyCustomizableReferenceProvider", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider$MyCustomizableReferenceProvider", "getReferencesByElement"));
                }
                FileReferenceSet set = FileReferenceSet.createSet((PsiElement)psiElement, (boolean)false, (boolean)true, (boolean)false);
                Function o = (Function)FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.getOptions());
                if (o != null) {
                    set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)o);
                }
                FileReference[] fileReferenceArray = set.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider$MyCustomizableReferenceProvider", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }

            @NotNull
            public PsiReference[] getReferencesByString(String s, @NotNull PsiElement psiElement, int i) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider$MyCustomizableReferenceProvider", "getReferencesByString"));
                }
                FileReferenceSet set = new FileReferenceSet(s, psiElement, i, (PsiReferenceProvider)this, true);
                Function o = (Function)FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION.getValue(this.getOptions());
                if (o != null) {
                    set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)o);
                }
                FileReference[] fileReferenceArray = set.getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/utils/WsReferenceProvidersHelper$MyPsiReferenceProvider$MyCustomizableReferenceProvider", "getReferencesByString"));
                }
                return fileReferenceArray;
            }
        }
    }
}

