/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ws.model.jam.WSJamWebMethod;
import com.intellij.ws.model.jam.WSJamWebService;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSJamWebMethodFinderRecursivePanel
extends FinderRecursivePanel<WSJamWebMethod> {
    private final WSJamWebService myPath;
    private final Module myModule;

    public WSJamWebMethodFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @NotNull WSJamWebService path, Module module) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ws/view/WSJamWebMethodFinderRecursivePanel", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/ws/view/WSJamWebMethodFinderRecursivePanel", "<init>"));
        }
        super(parent);
        this.myPath = path;
        this.myModule = module;
    }

    @Nullable
    protected JComponent createRightComponent(WSJamWebMethod method) {
        PsiMethod psiMethod = method.getPsiElement();
        DocumentationManager manager = DocumentationManager.getInstance((Project)this.myModule.getProject());
        DocumentationComponent component = new DocumentationComponent(manager);
        Disposer.register((Disposable)this, (Disposable)component);
        manager.fetchDocInfo((PsiElement)psiMethod, component);
        return component;
    }

    @NotNull
    protected List<WSJamWebMethod> getListItems() {
        ArrayList<WSJamWebMethod> items = new ArrayList<WSJamWebMethod>();
        for (WSJamWebMethod webMethod : this.myPath.getWebMethods()) {
            items.add(webMethod);
        }
        ArrayList<WSJamWebMethod> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/view/WSJamWebMethodFinderRecursivePanel", "getListItems"));
        }
        return arrayList;
    }

    @Nullable
    protected Icon getItemIcon(WSJamWebMethod method) {
        return method.getPsiElement().getIcon(0);
    }

    protected boolean hasChildren(WSJamWebMethod method) {
        return false;
    }

    @NotNull
    protected String getItemText(WSJamWebMethod method) {
        String string = PsiFormatUtil.formatMethod((PsiMethod)method.getPsiElement(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/view/WSJamWebMethodFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        WSJamWebMethod httpMethod = (WSJamWebMethod)this.getSelectedValue();
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && httpMethod != null) {
            return httpMethod.getPsiElement();
        }
        return super.getData(dataId);
    }
}

