/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomUtil;
import com.intellij.ws.wsdl.model.Binding;
import com.intellij.ws.wsdl.model.Definitions;
import com.intellij.ws.wsdl.model.Import;
import com.intellij.ws.wsdl.model.Message;
import com.intellij.ws.wsdl.model.Part;
import com.intellij.ws.wsdl.model.PortType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class WsdlDomUtils {
    private WsdlDomUtils() {
    }

    public static List<Message> getMessages(ConvertContext context) {
        List<Definitions> allDefinitions = WsdlDomUtils.getAllDefinitions(context);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Definitions definition : allDefinitions) {
            messages.addAll(definition.getMessages());
        }
        return messages;
    }

    public static List<Definitions> getAllDefinitions(ConvertContext context) {
        ArrayList<Definitions> all = new ArrayList<Definitions>();
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        if (definitions != null) {
            all.add(definitions);
            for (Import anImport : definitions.getImports()) {
                Definitions def;
                XmlDocument xml;
                PsiFile psiFile = FileReferenceUtil.findFile((PsiElement)anImport.getLocation().getXmlAttributeValue());
                if (!(psiFile instanceof XmlFile) || (xml = ((XmlFile)psiFile).getDocument()) == null || (def = (Definitions)DomUtil.findDomElement((PsiElement)xml.getRootTag(), Definitions.class, (boolean)false)) == null) continue;
                all.add(def);
            }
        }
        return all;
    }

    @Nullable
    public static Message findMessage(String name, ConvertContext context) {
        for (Message message : WsdlDomUtils.getMessages(context)) {
            if (!name.equals(message.getName().getValue())) continue;
            return message;
        }
        return null;
    }

    public static List<String> getWsdlNsPrefixes(ConvertContext context) {
        String targetNS;
        XmlTag rootTag;
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        if (definitions != null && (rootTag = definitions.getXmlTag()) != null && (targetNS = rootTag.getAttributeValue("targetNamespace")) != null) {
            ArrayList<String> res = new ArrayList<String>();
            for (XmlAttribute attribute : rootTag.getAttributes()) {
                String name = attribute.getName();
                if (!name.startsWith("xmlns:") || !attribute.getValue().equals(targetNS)) continue;
                res.add(name.substring(6));
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Nullable
    public static Definitions getDefinitions(ConvertContext context) {
        return (Definitions)context.getInvocationElement().getParentOfType(Definitions.class, true);
    }

    public static List<PortType> getPortTypes(ConvertContext context) {
        List<Definitions> allDefinitions = WsdlDomUtils.getAllDefinitions(context);
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        for (Definitions definition : allDefinitions) {
            portTypes.addAll(definition.getPortTypes());
        }
        return portTypes;
    }

    public static List<Binding> getBindings(ConvertContext context) {
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        return definitions == null ? Collections.emptyList() : definitions.getBindings();
    }

    @Nullable
    public static Message findMessage(String message, Definitions defs) {
        if (defs == null) {
            return null;
        }
        if (message.contains(":")) {
            message = message.substring(message.indexOf(":") + 1);
        }
        for (Message msg : defs.getMessages()) {
            if (!message.equals(msg.getName().getValue())) continue;
            return msg;
        }
        return null;
    }

    @Nullable
    public static PortType getPortType(Binding binding, ConvertContext context) {
        if (binding == null) {
            return null;
        }
        String value = (String)binding.getType().getValue();
        if (value != null) {
            String type = value.contains(":") ? value.substring(value.indexOf(":") + 1) : value;
            List<PortType> portTypes = WsdlDomUtils.getPortTypes(context);
            for (PortType portType : portTypes) {
                if (!type.equals(portType.getName().getValue())) continue;
                return portType;
            }
        }
        return null;
    }

    public static List<Part> getParts(ConvertContext context) {
        Definitions definitions = WsdlDomUtils.getDefinitions(context);
        return null;
    }
}

