/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.wsdl.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.ws.wsdl.converters.WsdlPartsDomReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PartReferenceConverter
implements CustomReferenceConverter<String> {
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        String v = (String)value.getValue();
        if (v != null && !StringUtil.isEmptyOrSpaces((String)v) && element instanceof XmlAttributeValue) {
            List strings = StringUtil.split((String)v, (String)" ");
            String[] parts = (String[])ContainerUtil.map2Array((Collection)strings, (Object[])new String[strings.size()], (Function)StringUtil.TRIMMER);
            int last = 0;
            ArrayList<WsdlPartsDomReference> refs = new ArrayList<WsdlPartsDomReference>(parts.length);
            for (String part : parts) {
                int start = v.indexOf(part, last);
                if (part.contains(":")) {
                    String ns = part.substring(0, part.indexOf(58));
                    start += ns.length() + 1;
                    part = part.substring(ns.length() + 1);
                }
                TextRange range = TextRange.from((int)(start + 1), (int)part.length());
                refs.add(new WsdlPartsDomReference((XmlAttributeValue)element, range, part));
                last = range.getEndOffset();
            }
            PsiReference[] psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/wsdl/converters/PartReferenceConverter", "createReferences"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/wsdl/converters/PartReferenceConverter", "createReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

