/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringContextDescriptor {
    public static final Key<SpringContextDescriptor> KEY = Key.create((String)"SpringContextDescriptor.KEY");
    public static final SpringContextDescriptor ALL_CONTEXTS = new SpringContextDescriptor(null, "all.contexts", "All Contexts");
    public static final SpringContextDescriptor LOCAL_CONTEXT;
    public static final SpringContextDescriptor DEFAULT;
    @Nullable
    private final Module myModule;
    private final String myId;
    private final String myName;

    public SpringContextDescriptor(@Nullable Module module, @NotNull String id, @NotNull String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/contexts/chooser/SpringContextDescriptor", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/contexts/chooser/SpringContextDescriptor", "<init>"));
        }
        this.myModule = module;
        this.myId = id;
        this.myName = name;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isPredefinedContext() {
        return this == LOCAL_CONTEXT || this == ALL_CONTEXTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringContextDescriptor that = (SpringContextDescriptor)o;
        if (!this.myId.equals(that.myId)) {
            return false;
        }
        return !(this.myModule != null ? !this.myModule.equals(that.myModule) : that.myModule != null);
    }

    public int hashCode() {
        int result = this.myModule != null ? this.myModule.hashCode() : 0;
        result = 31 * result + this.myId.hashCode();
        return result;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/chooser/SpringContextDescriptor", "getQualifiedName"));
        }
        return string;
    }

    static {
        DEFAULT = LOCAL_CONTEXT = new SpringContextDescriptor(null, "local.file.context", "Local File");
    }
}

