/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class SpringFileSetData {
    private final String myId;
    private String myName;
    private final List<String> myFiles;
    private final Set<String> myDependencies;
    private Set<String> myActiveProfiles;
    private boolean myRemoved;

    static SpringFileSetData create(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/facet/SpringFileSetData", "create"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/SpringFileSetData", "create"));
        }
        return new SpringFileSetData(id, name);
    }

    private SpringFileSetData(@NonNls @NotNull String id, @NotNull String name) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/spring/facet/SpringFileSetData", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/SpringFileSetData", "<init>"));
        }
        this.myFiles = new SmartList();
        this.myDependencies = new LinkedHashSet<String>();
        this.myActiveProfiles = new LinkedHashSet<String>();
        this.myId = id;
        this.myName = name;
    }

    public boolean isRemoved() {
        return this.myRemoved;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetData", "getId"));
        }
        return string;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/spring/facet/SpringFileSetData", "setName"));
        }
        this.myName = name;
    }

    @NotNull
    public List<String> getFiles() {
        List<String> list = this.myFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetData", "getFiles"));
        }
        return list;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/facet/SpringFileSetData", "setActiveProfiles"));
        }
        this.myActiveProfiles = activeProfiles;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringFileSetData", "getActiveProfiles"));
        }
        return set;
    }

    public Set<String> getDependencies() {
        return this.myDependencies;
    }

    public void addDependency(String dep) {
        this.myDependencies.add(dep);
    }

    public void addFile(@NonNls String url) {
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            this.myFiles.add(url);
        }
    }

    public void removeFile(@NonNls String url) {
        this.myFiles.remove(url);
    }

    void setRemoved(boolean removed) {
        this.myRemoved = removed;
    }

    public static SpringFileSetData create(SpringFileSetData original) {
        SpringFileSetData springFileSetData = new SpringFileSetData(original.getId(), original.getName());
        springFileSetData.setRemoved(original.isRemoved());
        springFileSetData.getDependencies().addAll(original.getDependencies());
        springFileSetData.getFiles().addAll(original.getFiles());
        springFileSetData.getActiveProfiles().addAll(original.getActiveProfiles());
        return springFileSetData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpringFileSetData data = (SpringFileSetData)o;
        if (!this.myId.equals(data.myId)) {
            return false;
        }
        return !(this.myName != null ? !this.myName.equals(data.myName) : data.myName != null);
    }

    public int hashCode() {
        int result = this.myId.hashCode();
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }
}

