/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamPsiMemberSpringBean<T extends PsiMember>
extends CommonModelElement.PsiBase
implements JamElement,
CommonSpringBean {
    public static final SemKey<JamPsiMemberSpringBean> PSI_MEMBER_SPRING_BEAN_JAM_KEY = JamService.JAM_ALIASING_ELEMENT_KEY.subKey("PsiMemberSpringBean", new SemKey[0]);

    @JamPsiConnector
    @NotNull
    public abstract T getPsiElement();

    @JamPsiValidity
    public abstract boolean isValid();

    @Override
    @Nullable
    public PsiType getBeanType(boolean considerFactories) {
        return this.getBeanType();
    }

    @Override
    @NotNull
    public String[] getAliases() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getAliases"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    protected List<String> getStringNames(List<JamStringAttributeElement<String>> elements) {
        SmartList aliases = new SmartList();
        for (JamStringAttributeElement<String> element : elements) {
            String aliasName = element.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
            aliases.add(aliasName);
        }
        return aliases;
    }

    @Override
    public SpringQualifier getSpringQualifier() {
        SpringJamQualifier jamQualifier = this.getQualifier();
        return jamQualifier == null ? DefaultSpringBeanQualifier.create(this) : jamQualifier;
    }

    @Nullable
    public SpringJamQualifier getQualifier() {
        Module module = this.getModule();
        if (module == null) {
            return null;
        }
        return SpringJamQualifier.findSpringJamQualifier(module, this.getPsiElement());
    }

    @Override
    public boolean isPrimary() {
        return AnnotationUtil.isAnnotated(this.getPsiElement(), (String)"org.springframework.context.annotation.Primary", (boolean)false);
    }

    @Override
    @NotNull
    public SpringProfile getProfile() {
        Module module = this.getModule();
        if (module == null) {
            SpringProfile springProfile = SpringProfile.DEFAULT;
            if (springProfile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getProfile"));
            }
            return springProfile;
        }
        Collection<PsiClass> annotationTypeClasses = JamAnnotationTypeUtil.getInstance(module).getAnnotationTypesWithChildren("org.springframework.context.annotation.Profile");
        SpringProfile springProfile = JamPsiMemberSpringBean.getProfile(annotationTypeClasses, this.getPsiElement());
        SpringProfile springProfile2 = springProfile != null ? springProfile : SpringProfile.DEFAULT;
        if (springProfile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getProfile"));
        }
        return springProfile2;
    }

    @Nullable
    private static SpringProfile getProfile(@NotNull Collection<PsiClass> annotationTypeClasses, @Nullable PsiMember profiledPsiElement) {
        if (annotationTypeClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationTypeClasses", "com/intellij/spring/model/jam/JamPsiMemberSpringBean", "getProfile"));
        }
        if (profiledPsiElement == null) {
            return null;
        }
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            String qname;
            if (AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE}) == null || (qname = annotationTypeClass.getQualifiedName()) == null || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)profiledPsiElement, (boolean)true, (String[])new String[]{qname})) == null) continue;
            return new SpringJamProfile(annotation, profiledPsiElement);
        }
        return profiledPsiElement instanceof PsiMethod ? JamPsiMemberSpringBean.getProfile(annotationTypeClasses, (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)profiledPsiElement, PsiClass.class, (boolean)true)) : null;
    }
}

