/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageListJamConverter
extends JamConverter<Collection<PsiPackage>> {
    public Collection<PsiPackage> fromString(@Nullable String s, JamStringAttributeElement<Collection<PsiPackage>> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return Collections.emptyList();
        }
        if (SpringConverterUtil.containsPatternReferences(s)) {
            return SpringConverterUtil.getPsiPackages(this.createReferences(context));
        }
        return SpringConverterUtil.getPackages(s, context.getPsiManager().getProject());
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<Collection<PsiPackage>> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageListJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = SpringReferenceUtils.getPsiPackagesReferences((PsiElement)psiLiteral, context.getStringValue(), ElementManipulators.getOffsetInElement((PsiElement)psiLiteral));
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageListJamConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

