/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.javaConfig;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.JavaConfigConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringJavaExternalBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringOldJavaConfigurationUtil {
    public static List<JavaConfigConfiguration> getJavaConfigurations(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "getJavaConfigurations"));
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        return jamService.getJamClassElements(JavaConfigConfiguration.META, "org.springframework.config.java.annotation.Configuration", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
    }

    @NotNull
    public static List<SpringBeanPointer> findExternalBeans(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        PsiClass psiClass = psiMethod.getContainingClass();
        if (module == null || psiClass == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeans"));
            }
            return list;
        }
        if (SpringOldJavaConfigurationUtil.getExternalBean(psiMethod) == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeans"));
            }
            return list;
        }
        SmartList extBeans = new SmartList();
        for (SpringModel model : SpringManager.getInstance(psiMethod.getProject()).getAllModels(module)) {
            boolean hasJavaConfigBean = SpringModelSearchers.doesBeanExist((CommonSpringModel)model, SpringModelSearchParameters.byClass(psiClass));
            if (!hasJavaConfigBean) continue;
            String externalBeanName = psiMethod.getName();
            for (SpringBeanPointer springBean : model.getAllDomBeans()) {
                String beanName = springBean.getName();
                if (!externalBeanName.equals(beanName) && !Arrays.asList(springBean.getAliases()).contains(externalBeanName)) continue;
                extBeans.add(springBean);
            }
        }
        SmartList smartList = extBeans;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeans"));
        }
        return smartList;
    }

    @NotNull
    public static List<SpringJavaExternalBean> findExternalBeanReferences(CommonSpringBean springBean) {
        XmlTag element = springBean.getXmlTag();
        if (element == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeanReferences"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeanReferences"));
            }
            return list;
        }
        Set<String> beanNames = SpringBeanUtils.getInstance().findBeanNames(springBean);
        if (beanNames.isEmpty()) {
            List<SpringJavaExternalBean> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeanReferences"));
            }
            return list;
        }
        ArrayList<SpringJavaExternalBean> extBeans = new ArrayList<SpringJavaExternalBean>();
        for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
            if (!(springJavaConfiguration instanceof JavaConfigConfiguration)) continue;
            for (SpringJavaExternalBean springJavaExternalBean : ((JavaConfigConfiguration)springJavaConfiguration).getExternalBeans()) {
                PsiMethod psiMethod = springJavaExternalBean.getPsiElement();
                if (!beanNames.contains(psiMethod.getName())) continue;
                extBeans.add(springJavaExternalBean);
            }
        }
        ArrayList<SpringJavaExternalBean> arrayList = extBeans;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/javaConfig/SpringOldJavaConfigurationUtil", "findExternalBeanReferences"));
        }
        return arrayList;
    }

    @Nullable
    public static SpringJavaExternalBean getExternalBean(PsiMethod psiMethod) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMethod);
        if (module != null) {
            for (SpringJavaConfiguration springJavaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations(module)) {
                if (!(springJavaConfiguration instanceof JavaConfigConfiguration) || !psiMethod.getContainingFile().equals(springJavaConfiguration.getPsiClass().getContainingFile())) continue;
                for (SpringJavaExternalBean springJavaExternalBean : ((JavaConfigConfiguration)springJavaConfiguration).getExternalBeans()) {
                    if (!psiMethod.equals(springJavaExternalBean.getPsiElement())) continue;
                    return springJavaExternalBean;
                }
            }
        }
        return null;
    }
}

