/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.qualifiers;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.QualifierAttribute;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xml.NameValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="@Qualifier")
public class SpringJamQualifier
extends CommonModelElement.PsiBase
implements JamElement,
SpringQualifier {
    private final PsiAnnotation myAnno;
    protected final PsiModifierListOwner myModifierListOwner;
    private final Project myProject;

    public SpringJamQualifier(@NotNull PsiAnnotation anno, @Nullable PsiModifierListOwner modifierListOwner) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "<init>"));
        }
        this.myAnno = anno;
        this.myModifierListOwner = modifierListOwner;
        this.myProject = anno.getProject();
    }

    public PsiAnnotation getAnnotation() {
        return this.myAnno;
    }

    @NameValue
    @Nullable
    public String getQualifiedName() {
        return (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)this.myAnno.findAttributeValue(null), String.class);
    }

    @NotNull
    public PsiModifierListOwner getPsiElement() {
        Object object = this.myModifierListOwner == null ? this.getType() : this.myModifierListOwner;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "getPsiElement"));
        }
        return object;
    }

    @NotNull
    private PsiClass getType() {
        String annoQualifiedName = this.myAnno.getQualifiedName();
        PsiClass psiClass = annoQualifiedName == null ? null : JavaPsiFacade.getInstance((Project)this.myProject).findClass(annoQualifiedName, this.myAnno.getResolveScope());
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "getType"));
        }
        return psiClass;
    }

    @Override
    public PsiClass getQualifierType() {
        return this.getType();
    }

    @Override
    public String getQualifierValue() {
        return this.getQualifiedName();
    }

    @Override
    @NotNull
    public List<? extends QualifierAttribute> getQualifierAttributes() {
        PsiNameValuePair[] attributes = this.myAnno.getParameterList().getAttributes();
        SmartList list = new SmartList();
        for (final PsiNameValuePair pair : attributes) {
            final String name = pair.getName();
            if (name == null || name.equals("value")) continue;
            list.add(new QualifierAttribute(){

                @Override
                public String getAttributeKey() {
                    return name;
                }

                @Override
                public Object getAttributeValue() {
                    return JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)pair.getValue(), Object.class);
                }
            });
        }
        SmartList smartList = list;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "getQualifierAttributes"));
        }
        return smartList;
    }

    public static SpringJamQualifier findSpringJamQualifier(@NotNull Module module, @NotNull PsiModifierListOwner element) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "findSpringJamQualifier"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "findSpringJamQualifier"));
        }
        JamAnnotationTypeUtil jamAnnotationTypeUtil = JamAnnotationTypeUtil.getInstance(module);
        List<PsiClass> annotationTypeClasses = jamAnnotationTypeUtil.getQualifierAnnotationTypesWithChildren();
        for (PsiClass annotationTypeClass : annotationTypeClasses) {
            PsiAnnotation annotation;
            String qname;
            if (!SpringJamQualifier.isElementTypeAccepted(annotationTypeClass, element) || (qname = annotationTypeClass.getQualifiedName()) == null || qname.equals("javax.inject.Named") || (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{qname})) == null) continue;
            return new SpringJamQualifier(annotation, element);
        }
        PsiAnnotation namedAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (boolean)true, (String[])new String[]{"javax.inject.Named"});
        if (namedAnnotation != null) {
            return new SpringJamQualifier(namedAnnotation, element);
        }
        return null;
    }

    private static boolean isElementTypeAccepted(@NotNull PsiClass annotationTypeClass, @NotNull PsiModifierListOwner element) {
        if (annotationTypeClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationTypeClass", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "isElementTypeAccepted"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/model/jam/qualifiers/SpringJamQualifier", "isElementTypeAccepted"));
        }
        if (element instanceof PsiClass) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE}) != null;
        }
        if (element instanceof PsiMethod) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.METHOD}) != null;
        }
        if (element instanceof PsiField) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.FIELD}) != null;
        }
        if (element instanceof PsiParameter) {
            return AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationTypeClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.PARAMETER}) != null;
        }
        return false;
    }
}

