/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.ws.util.XsdUtil;
import com.intellij.util.ArrayUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PayloadRootReference
extends PsiReferenceBase<PsiElement> {
    private final XmlFile myXmlFile;
    private final String myNamespace;

    public PayloadRootReference(PsiElement element, TextRange textRange, @NotNull XmlFile xmlFile, @NotNull String namespace) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/spring/ws/converters/PayloadRootReference", "<init>"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/spring/ws/converters/PayloadRootReference", "<init>"));
        }
        super(element, textRange);
        this.myXmlFile = xmlFile;
        this.myNamespace = namespace;
    }

    public PsiElement resolve() {
        Map<String, XsdUtil.XsdElement> map = XsdUtil.getChildrenElements((XmlElement)this.myXmlFile, this.myNamespace);
        XsdUtil.XsdElement xsdElement = map.get(this.getValue().trim());
        return xsdElement == null ? null : xsdElement.getDeclaration();
    }

    @NotNull
    public Object[] getVariants() {
        Set<String> map = XsdUtil.getChildrenElements((XmlElement)this.myXmlFile, this.myNamespace).keySet();
        Object[] objectArray = ArrayUtil.toObjectArray(map);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/converters/PayloadRootReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }
}

