/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.spring.model.values.converters.resources.ResourceTypeCondition;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.GenericDomValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringWebServicesResourceTypeProvider
implements SpringResourceTypeProvider {
    private Map<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> myFilterMap = new HashMap();

    public SpringWebServicesResourceTypeProvider() {
        this.addResourceFilter("org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition", "wsdl", "wsdl");
        this.addResourceFilter("org.springframework.xml.xsd.SimpleXsdSchema", "xsd", "xsd");
        this.addResourceFilter("org.springframework.ws.soap.server.endpoint.interceptor.PayloadValidatingInterceptor", "schema", "xsd");
        this.addResourceFilter("org.springframework.ws.server.endpoint.interceptor.PayloadTransformingInterceptor", "requestXslt", "xslt");
        this.addResourceFilter("org.springframework.ws.server.endpoint.interceptor.PayloadTransformingInterceptor", "responseXslt", "xslt");
        this.addResourceFilter("org.springframework.ws.soap.security.xwss.XwsSecurityInterceptor", "policyConfiguration", "xml");
        this.addConstructorArgResourceFilter("org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition", "wsdl");
        this.addConstructorArgResourceFilter("org.springframework.xml.xsd.SimpleXsdSchema", "xsd");
        this.addConstructorArgResourceFilter("org.springframework.xml.xsd.commons.CommonsXsdSchema", "xsd");
    }

    private void addConstructorArgResourceFilter(String beanClass, String fileExtension) {
        this.myFilterMap.put((Condition<GenericDomValue>)SpringValueConditionFactory.createBeanClassConstructorArgCondition((String)beanClass), (Condition<PsiFileSystemItem>)new ResourceTypeCondition(new String[]{fileExtension}));
    }

    private void addResourceFilter(@NotNull String beanProperty, @NotNull String propertyName, @NotNull String fileExtension) {
        if (beanProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanProperty", "com/intellij/spring/ws/converters/SpringWebServicesResourceTypeProvider", "addResourceFilter"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/spring/ws/converters/SpringWebServicesResourceTypeProvider", "addResourceFilter"));
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/intellij/spring/ws/converters/SpringWebServicesResourceTypeProvider", "addResourceFilter"));
        }
        this.myFilterMap.put((Condition<GenericDomValue>)SpringValueConditionFactory.createBeanPropertyCondition((String)beanProperty, (String[])new String[]{propertyName}), (Condition<PsiFileSystemItem>)new ResourceTypeCondition(new String[]{fileExtension}));
    }

    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/ws/converters/SpringWebServicesResourceTypeProvider", "getResourceFilter"));
        }
        for (Map.Entry<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> entry : this.myFilterMap.entrySet()) {
            if (!entry.getKey().value((Object)genericDomValue)) continue;
            return entry.getValue();
        }
        return null;
    }
}

