/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.jam;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamSimpleReference;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import com.intellij.spring.ws.util.SpringWebServicesUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamespaceReferenceConverter
extends JamSimpleReferenceConverter<PsiFile> {
    public PsiFile fromString(@Nullable String namespace, JamStringAttributeElement<PsiFile> context) {
        VirtualFile file = this.getSchemas(context).get(namespace);
        return file == null ? null : context.getPsiManager().findFile(file);
    }

    @NotNull
    public JamSimpleReference<PsiFile> createReference(JamStringAttributeElement<PsiFile> context) {
        JamSimpleReference jamSimpleReference = super.createReference(context);
        if (jamSimpleReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/jam/NamespaceReferenceConverter", "createReference"));
        }
        return jamSimpleReference;
    }

    public LookupElement[] getLookupVariants(JamStringAttributeElement<PsiFile> context) {
        HashSet variants = new HashSet();
        for (Map.Entry<String, VirtualFile> entry : this.getSchemas(context).entrySet()) {
            variants.add(SpringWebServicesUtil.createLookupElementFor(entry.getKey(), context.getPsiManager().findFile(entry.getValue())));
        }
        return variants.toArray(new LookupElement[variants.size()]);
    }

    private Map<String, VirtualFile> getSchemas(JamStringAttributeElement<PsiFile> context) {
        Module module;
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (psiElement != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement)) != null) {
            return SpringWebServiceJamUtil.getSchemas(module);
        }
        return Collections.emptyMap();
    }
}

