/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.ui.AjCompilerOptionsPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AjCompilerConfigurable
implements Configurable {
    private final AjCompilerSettings mySettings;
    private final Project myProject;
    private AjCompilerOptionsPanel myOptionsPanel;

    public AjCompilerConfigurable(@NotNull AjCompilerSettings settings, @NotNull Project project) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjCompilerConfigurable", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/AjCompilerConfigurable", "<init>"));
        }
        this.myOptionsPanel = null;
        this.mySettings = settings;
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return null;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myOptionsPanel = new AjCompilerOptionsPanel(this.myProject);
        return this.myOptionsPanel.getComponent();
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myOptionsPanel.getAjcPath(), (String)this.mySettings.ajcPath) || !Comparing.equal((String)this.myOptionsPanel.getCmdLineParams(), (String)this.mySettings.cmdLineParams) || !Comparing.equal((Object)this.myOptionsPanel.isGenerateDebugInfo(), (Object)this.mySettings.debugInfo) || !Comparing.equal((Object)this.myOptionsPanel.isDelegateToJavac(), (Object)this.mySettings.delegateToJavac) || !Comparing.equal((Object)this.myOptionsPanel.areAptOptionsEnabled(), (Object)this.mySettings.aptOptionsEnabled);
    }

    public void apply() throws ConfigurationException {
        this.mySettings.ajcPath = this.myOptionsPanel.getAjcPath();
        this.mySettings.cmdLineParams = this.myOptionsPanel.getCmdLineParams();
        this.mySettings.debugInfo = this.myOptionsPanel.isGenerateDebugInfo();
        this.mySettings.delegateToJavac = this.myOptionsPanel.isDelegateToJavac();
        this.mySettings.aptOptionsEnabled = this.myOptionsPanel.areAptOptionsEnabled();
    }

    public void reset() {
        this.myOptionsPanel.setAjcPath(this.mySettings.ajcPath);
        this.myOptionsPanel.setHeapSize(this.mySettings.heapSize);
        this.myOptionsPanel.setCmdLineParams(this.mySettings.cmdLineParams);
        this.myOptionsPanel.setGenerateDebugInfo(this.mySettings.debugInfo);
        this.myOptionsPanel.setDelegateToJavac(this.mySettings.delegateToJavac);
        this.myOptionsPanel.setAptOptionsEnabled(this.mySettings.aptOptionsEnabled);
    }

    public void disposeUIResources() {
        this.myOptionsPanel = null;
    }
}

