/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build.config;

import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    private final Project myProject;

    public AjBuildProcessParametersProvider(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/config/AjBuildProcessParametersProvider", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public List<String> getClassPath() {
        String toolPath = AjIdeaCompilerSettings.getSettings((Project)this.myProject).ajcPath;
        List<String> list = Collections.singletonList(toolPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/config/AjBuildProcessParametersProvider", "getClassPath"));
        }
        return list;
    }

    public static boolean checkCompilerJar(@Nullable String path) {
        return !StringUtil.isEmptyOrSpaces((String)path) && JarUtil.containsClass((String)path, (String)"org.aspectj.tools.ajc.Main");
    }
}

