/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.psi.stub;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.aspectj.index.stub.AspectJInterTypeFieldIndex;
import com.intellij.lang.aspectj.parsing.AspectJElementType;
import com.intellij.lang.aspectj.psi.PsiInterTypeField;
import com.intellij.lang.aspectj.psi.impl.PsiInterTypeFieldImpl;
import com.intellij.lang.aspectj.psi.stub.AjStubElementType;
import com.intellij.lang.aspectj.psi.stub.PsiInterTypeFieldStub;
import com.intellij.lang.aspectj.psi.stub.impl.PsiInterTypeFieldStubImpl;
import com.intellij.lang.aspectj.psi.stub.impl.StubBaseWithFlags;
import com.intellij.lang.aspectj.psi.tree.InterTypeFieldElement;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AjFieldElementType
extends AjStubElementType<PsiInterTypeFieldStub, PsiInterTypeField> {
    public AjFieldElementType() {
        super("INTER_TYPE_FIELD");
    }

    @NotNull
    public ASTNode createCompositeNode() {
        InterTypeFieldElement interTypeFieldElement = new InterTypeFieldElement();
        if (interTypeFieldElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "createCompositeNode"));
        }
        return interTypeFieldElement;
    }

    public PsiInterTypeField createPsi(@NotNull PsiInterTypeFieldStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "createPsi"));
        }
        return new PsiInterTypeFieldImpl(stub);
    }

    @Override
    public PsiInterTypeField createPsi(ASTNode node) {
        return new PsiInterTypeFieldImpl(node);
    }

    public PsiInterTypeFieldStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        boolean isDeprecatedByComment = false;
        boolean hasDeprecatedAnnotation = false;
        boolean hasDocComment = false;
        String className = null;
        String name = null;
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                hasDocComment = true;
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation((LighterAST)tree, (LighterASTNode)child);
                continue;
            }
            if (type == AspectJElementType.INTER_TYPE_REFERENCE) {
                className = AjFieldElementType.getReferencedClassName(tree, child);
                continue;
            }
            if (type != JavaTokenType.IDENTIFIER) continue;
            name = RecordUtil.intern((CharTable)tree.getCharTable(), (LighterASTNode)child);
        }
        TypeInfo typeInfo = TypeInfo.create((LighterAST)tree, (LighterASTNode)node, (StubElement)parentStub);
        byte flags = StubBaseWithFlags.pack(isDeprecatedByComment, hasDeprecatedAnnotation, hasDocComment);
        return new PsiInterTypeFieldStubImpl(parentStub, className, name, typeInfo, flags);
    }

    public void serialize(@NotNull PsiInterTypeFieldStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "serialize"));
        }
        dataStream.writeName(stub.getClassName());
        dataStream.writeName(stub.getName());
        TypeInfo.writeTYPE((StubOutputStream)dataStream, (TypeInfo)stub.getType(false));
        dataStream.writeByte((int)((PsiInterTypeFieldStubImpl)stub).getFlags());
    }

    @NotNull
    public PsiInterTypeFieldStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "deserialize"));
        }
        StringRef className = dataStream.readName();
        StringRef name = dataStream.readName();
        TypeInfo typeInfo = TypeInfo.readTYPE((StubInputStream)dataStream);
        byte flags = dataStream.readByte();
        PsiInterTypeFieldStubImpl psiInterTypeFieldStubImpl = new PsiInterTypeFieldStubImpl(parentStub, StringRef.toString((StringRef)className), StringRef.toString((StringRef)name), typeInfo, flags);
        if (psiInterTypeFieldStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "deserialize"));
        }
        return psiInterTypeFieldStubImpl;
    }

    public void indexStub(@NotNull PsiInterTypeFieldStub stub, @NotNull IndexSink sink) {
        String className;
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/aspectj/psi/stub/AjFieldElementType", "indexStub"));
        }
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(JavaStubIndexKeys.FIELDS, (Object)name);
            if (RecordUtil.isStaticNonPrivateMember((StubElement)stub)) {
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_NAMES, (Object)name);
                sink.occurrence(JavaStubIndexKeys.JVM_STATIC_MEMBERS_TYPES, (Object)stub.getType(false).getShortTypeText());
            }
        }
        if ((className = stub.getClassName()) != null) {
            sink.occurrence(AspectJInterTypeFieldIndex.KEY, (Object)className);
        }
    }
}

