/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.search;

import com.intellij.lang.aspectj.index.stub.AjShortClassNameIndex;
import com.intellij.lang.aspectj.psi.PsiInterTypeClass;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AjClassFinder
extends PsiElementFinder {
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        String shortName;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/aspectj/search/AjClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/aspectj/search/AjClassFinder", "findClass"));
        }
        Project project = scope.getProject();
        if (project != null && (shortName = AjClassFinder.getShortName(qualifiedName)) != null) {
            Collection<PsiInterTypeClass> classes = AjShortClassNameIndex.getInstance().get(shortName, project, scope);
            for (PsiInterTypeClass aClass : classes) {
                if (!qualifiedName.equals(aClass.getQualifiedName())) continue;
                return aClass;
            }
        }
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        Collection<PsiInterTypeClass> classes;
        String shortName;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/aspectj/search/AjClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/aspectj/search/AjClassFinder", "findClasses"));
        }
        Project project = scope.getProject();
        if (project != null && (shortName = AjClassFinder.getShortName(qualifiedName)) != null && !(classes = AjShortClassNameIndex.getInstance().get(shortName, project, scope)).isEmpty()) {
            ArrayList result = ContainerUtil.newArrayList();
            for (PsiInterTypeClass aClass : classes) {
                if (!qualifiedName.equals(aClass.getQualifiedName())) continue;
                result.add(aClass);
            }
            int count = result.size();
            if (count > 0) {
                PsiClass[] psiClassArray = result.toArray(new PsiClass[count]);
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/search/AjClassFinder", "findClasses"));
                }
                return psiClassArray;
            }
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/search/AjClassFinder", "findClasses"));
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    private static String getShortName(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/lang/aspectj/search/AjClassFinder", "getShortName"));
        }
        int pos = qName.lastIndexOf(46);
        return pos >= 0 && pos < qName.length() - 1 ? qName.substring(pos + 1) : null;
    }
}

