/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.setup;

import com.intellij.configurationStore.StateStorageManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.config.AjIdeaCompilerSettings;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.FList;
import java.io.File;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AjPostStartupActivity
implements StartupActivity,
DumbAware {
    private static final String ASPECT_PATH_NOTIFICATION_KEY = "aspect.path.notification.shown";

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/setup/AjPostStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || project.isDefault()) {
            return;
        }
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        if (!properties.isValueSet(ASPECT_PATH_NOTIFICATION_KEY)) {
            List<String> libNames;
            Element configElement = AjPostStartupActivity.getConfigElement(project);
            if (configElement != null && !(libNames = AjPostStartupActivity.getAspectPathEntries(configElement)).isEmpty()) {
                String message = AspectJBundle.message("migration.project.aspectpath", "<b>" + StringUtil.join(libNames, (String)"</b><b>") + "</b>.");
                Notifications.Bus.notify((Notification)new Notification("AspectJ", AspectJBundle.message("plugin.title", new Object[0]), message, NotificationType.WARNING), (Project)project);
            }
            properties.setValue(ASPECT_PATH_NOTIFICATION_KEY, true);
        }
    }

    @Nullable
    private static Element getConfigElement(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/setup/AjPostStartupActivity", "getConfigElement"));
        }
        IProjectStore store = ProjectKt.getStateStore((Project)project);
        State stateSpec = StoreUtil.getStateSpec(AjIdeaCompilerSettings.class);
        if (stateSpec != null && store.getStorageScheme() == StorageScheme.DIRECTORY_BASED) {
            StateStorageManager sm = store.getStateStorageManager();
            for (Storage spec : stateSpec.storages()) {
                try {
                    StateStorage storage = sm.getStateStorage(spec);
                    if (storage.hasState(stateSpec.name(), false)) {
                        File file = new File(sm.expandMacros(spec.value()));
                        return file.exists() ? JDOMUtil.load((File)file) : null;
                    }
                }
                catch (Throwable e) {
                    Logger.getInstance(AjPostStartupActivity.class).debug(e);
                }
            }
        }
        return null;
    }

    private static List<String> getAspectPathEntries(Element configElement) {
        FList libNames = FList.emptyList();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            InputSource source = new JDOMSource(configElement).getInputSource();
            NodeList nodes = (NodeList)xpath.evaluate("/project/component[@name='AjcSettings']/option[@name='aspectPath']/*/option/@value", source, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                String libName = nodes.item(i).getNodeValue();
                libNames = libNames.prepend((Object)libName);
            }
        }
        catch (XPathExpressionException e) {
            Logger.getInstance(AjPostStartupActivity.class).warn((Throwable)e);
        }
        return libNames;
    }
}

