/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.play.language.PlayFileElementTypes;
import com.intellij.play.language.PlayLanguage;
import com.intellij.play.language.groovy.PlayGroovyFileImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.ConfigurableTemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public class PlayFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements ConfigurableTemplateLanguageFileViewProvider {
    public PlayFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
    }

    @NotNull
    public Language getBaseLanguage() {
        PlayLanguage playLanguage = PlayLanguage.INSTANCE;
        if (playLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayFileViewProvider", "getBaseLanguage"));
        }
        return playLanguage;
    }

    @NotNull
    public Set<Language> getLanguages() {
        THashSet tHashSet = new THashSet(Arrays.asList(this.getBaseLanguage(), this.getTemplateDataLanguage(), this.getGroovyLanguage()));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayFileViewProvider", "getLanguages"));
        }
        return tHashSet;
    }

    protected PlayFileViewProvider cloneInner(VirtualFile copy) {
        return new PlayFileViewProvider(this.getManager(), copy, false);
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = StdLanguages.HTML;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayFileViewProvider", "getTemplateDataLanguage"));
        }
        return language;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/intellij/play/language/PlayFileViewProvider", "createFile"));
        }
        if (lang == this.getBaseLanguage()) {
            return ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)).createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)PlayFileElementTypes.TEMPLATE_DATA);
            return file;
        }
        if (lang == this.getGroovyLanguage()) {
            return new PlayGroovyFileImpl((FileViewProvider)this);
        }
        return null;
    }

    public Language getGroovyLanguage() {
        return GroovyLanguage.INSTANCE;
    }
}

