/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.language;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.play.language.PlayActionCompositeElement;
import com.intellij.play.language.PlayActionElementType;
import com.intellij.play.language.PlayCompositeElementType;
import com.intellij.play.language.PlayCompositeGroovyExpressionElement;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.PlayParser;
import com.intellij.play.language.TagExpressionCompositeElement;
import com.intellij.play.language.TagExpressionElementType;
import com.intellij.play.language.groovy.GroovyExpressionLazyParseableElementType;
import com.intellij.play.language.lexer.PlayLexer;
import com.intellij.play.language.psi.PlayPsiFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PlayParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.WHITE_SPACE});
    private static final TokenSet COMMENT = TokenSet.create((IElementType[])new IElementType[]{PlayElementTypes.COMMENT_START, PlayElementTypes.COMMENT_END, PlayElementTypes.COMMENT_TEXT});

    @NotNull
    public Lexer createLexer(Project project) {
        PlayLexer playLexer = PlayLexer.createLexer();
        if (playLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "createLexer"));
        }
        return playLexer;
    }

    public PsiParser createParser(Project project) {
        return new PlayParser();
    }

    public IFileElementType getFileNodeType() {
        return PlayElementTypes.PLAY_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = WHITE_SPACE;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = PlayElementTypes.STRING_LITERALS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type instanceof PlayCompositeElementType) {
            PsiElement psiElement = ((PlayCompositeElementType)type).createPsiElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type instanceof PlayActionElementType) {
            PlayActionCompositeElement playActionCompositeElement = new PlayActionCompositeElement(node);
            if (playActionCompositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "createElement"));
            }
            return playActionCompositeElement;
        }
        if (type instanceof TagExpressionElementType) {
            TagExpressionCompositeElement tagExpressionCompositeElement = new TagExpressionCompositeElement(node);
            if (tagExpressionCompositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "createElement"));
            }
            return tagExpressionCompositeElement;
        }
        if (type instanceof GroovyExpressionLazyParseableElementType) {
            PlayCompositeGroovyExpressionElement playCompositeGroovyExpressionElement = new PlayCompositeGroovyExpressionElement(node);
            if (playCompositeGroovyExpressionElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/language/PlayParserDefinition", "createElement"));
            }
            return playCompositeGroovyExpressionElement;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PlayPsiFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    public String toString() {
        return PlayParserDefinition.class.getName();
    }
}

