/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.play.utils.PlayPathUtils;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PlayPathViewsPsiReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayPathViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayPathViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayPathViewsPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        FileReferenceSet set = FileReferenceSet.createSet((PsiElement)element, (boolean)true, (boolean)false, (boolean)false);
        set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, psiFile -> {
            PsiDirectory viewsDirectory = PlayPathUtils.getViewsDirectory(module);
            if (viewsDirectory != null) {
                return Collections.singleton(viewsDirectory);
            }
            return Collections.emptyList();
        });
        FileReference[] fileReferenceArray = set.getAllReferences();
        if (fileReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayPathViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        return fileReferenceArray;
    }
}

