/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.references;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.play.references.PlayControllerActionPsiReferenceProvider;
import com.intellij.play.references.PlayPathViewsPsiReferenceProvider;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PlayRenderViewsPsiReferenceProvider
extends PsiReferenceProvider {
    private PlayControllerActionPsiReferenceProvider myActionProvider = new PlayControllerActionPsiReferenceProvider();
    private PlayPathViewsPsiReferenceProvider myViewsTemplatesProvider = new PlayPathViewsPsiReferenceProvider();

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/play/references/PlayRenderViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/play/references/PlayRenderViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        String text = ElementManipulators.getValueText((PsiElement)element);
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRenderViewsPsiReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = text.startsWith("@") ? this.myActionProvider.getReferencesByElement(element, context) : this.myViewsTemplatesProvider.getReferencesByElement(element, context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/references/PlayRenderViewsPsiReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

