/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackageReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class LoggerNameReferenceProvider
extends PsiReferenceProvider {
    private final String myKeyPrefix;

    public LoggerNameReferenceProvider(String prefix) {
        this.myKeyPrefix = prefix;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider", "getReferencesByElement"));
        }
        String packageText = StringUtil.substringAfter((String)element.getText(), (String)this.myKeyPrefix);
        if (packageText == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        JavaClassReferenceSet set = new JavaClassReferenceSet(packageText, element, this.myKeyPrefix.length(), false, new JavaClassReferenceProvider());
        PackageReferenceSet packageReferenceSet = new PackageReferenceSet(packageText, element, this.myKeyPrefix.length());
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])set.getReferences(), (Object[])packageReferenceSet.getPsiReferences());
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggerNameReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

