/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        Module module2 = module;
        synchronized (module2) {
            List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
                List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring-configuration-metadata.json", JsonFile.class);
                ArrayList<SpringBootApplicationMetaConfigKey> allKeys = new ArrayList<SpringBootApplicationMetaConfigKey>();
                for (JsonFile configMetadataFile : metaInfConfigFiles) {
                    List<SpringBootApplicationMetaConfigKey> keys = SpringBootApplicationMetaConfigKeyManagerImpl.getConfigKeysForFile(module, configMetadataFile);
                    allKeys.addAll(keys);
                }
                return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            List<SpringBootApplicationMetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
            return ContainerUtil.concat((List)fromLibraries, localKeys);
        }
    }

    private static List<SpringBootApplicationMetaConfigKey> getConfigKeysForFile(Module module, JsonFile jsonFile) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)jsonFile, () -> {
            ArrayList keys = new ArrayList();
            Processor collect = Processors.cancelableCollectProcessor(keys);
            SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(jsonFile);
            parser.processKeys(module, (Processor<SpringBootApplicationMetaConfigKey>)collect);
            return CachedValueProvider.Result.create(keys, (Object[])new Object[]{jsonFile, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static List<SpringBootApplicationMetaConfigKey> getLocalMetaConfigKeys(Module localModule) {
        return (List)CachedValuesManager.getManager((Project)localModule.getProject()).getCachedValue((UserDataHolder)localModule, () -> {
            HashSet allModules = new HashSet();
            ModuleUtilCore.getDependencies((Module)localModule, (Set)allModules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (ContainerUtil.process((Iterable)allModules, module -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor((Module)module))) {
                Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)localModule.getProject());
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
            }
            ArrayList allKeys = new ArrayList();
            for (Module module2 : allModules) {
                File localJsonFile = SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFile(module2, unitTestMode);
                if (localJsonFile == null) continue;
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(module2, localJsonFile);
                parser.processKeys(localModule, (Processor<SpringBootApplicationMetaConfigKey>)collect);
                allKeys.addAll(keys);
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static File findLocalMetadataJsonFile(Module module, boolean unitTestMode) {
        if (!unitTestMode) {
            String outputDir = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (outputDir == null) {
                return null;
            }
            String metadataJsonPath = outputDir + "/META-INF/" + "spring-configuration-metadata.json";
            File localJsonFile = new File(metadataJsonPath);
            if (!localJsonFile.exists()) {
                return null;
            }
            return localJsonFile;
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/spring-configuration-metadata.json");
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File localJsonFile = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.findApplicationMetaConfigKey(module, (Condition<SpringBootApplicationMetaConfigKey>)Conditions.alwaysTrue(), configKey);
    }

    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @NotNull Condition<SpringBootApplicationMetaConfigKey> additionalCondition, @Nullable String configKey) {
        List matchingKeys;
        if (additionalCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalCondition", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findApplicationMetaConfigKey"));
        }
        if (configKey == null || module == null) {
            return null;
        }
        List allKeys = this.getAllMetaConfigKeys(module);
        List list = matchingKeys = additionalCondition == Condition.TRUE ? allKeys : ContainerUtil.filter(allKeys, additionalCondition);
        if (matchingKeys.isEmpty()) {
            return null;
        }
        SpringBootApplicationMetaConfigKey exact = (SpringBootApplicationMetaConfigKey)ContainerUtil.find((Iterable)matchingKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (exact != null) {
            return exact;
        }
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.find((Iterable)matchingKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createMatchesCondition(configKey));
    }

    @NotNull
    public List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List allKeys = this.getAllMetaConfigKeys(psiElement);
        if (allKeys.isEmpty()) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List exact = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
            }
            return list;
        }
        List list = ContainerUtil.findAll((Collection)allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createMatchesCondition(configKey));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "findAllApplicationMetaConfigKeys"));
        }
        return list;
    }

    @NotNull
    private static Condition<SpringBootApplicationMetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "createNormalAccessTypeMatchingCondition"));
        }
        Condition condition = key -> {
            if (configKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "lambda$createNormalAccessTypeMatchingCondition$4"));
            }
            return key.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL}) && StringUtil.equalsIgnoreCase((CharSequence)key.getName(), (CharSequence)configKey);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "createNormalAccessTypeMatchingCondition"));
        }
        return condition;
    }

    private static Condition<SpringBootApplicationMetaConfigKey> createMatchesCondition(@NotNull String configKey) {
        if (configKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "createMatchesCondition"));
        }
        return key -> {
            if (configKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configKey", "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl", "lambda$createMatchesCondition$5"));
            }
            return key.matches(configKey);
        };
    }
}

