/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.ObjectUtils;
import java.util.Collection;

public class SpringBootAdditionalConfigConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    protected void processModule(MethodReferencesSearch.SearchParameters queryParameters, String prefix, Module module) {
        if (!SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor((Module)module)) {
            return;
        }
        Project project = module.getProject();
        PsiPackage metaInfPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metaInfPackage == null) {
            return;
        }
        GlobalSearchScope metaInfPackageScope = PackageScope.packageScopeWithoutLibraries((PsiPackage)metaInfPackage, (boolean)false);
        GlobalSearchScope metaInfInModuleScope = module.getModuleScope(false).intersectWith(metaInfPackageScope);
        Collection additionalConfigs = FilenameIndex.getVirtualFilesByName((Project)project, (String)"additional-spring-configuration-metadata.json", (GlobalSearchScope)metaInfInModuleScope);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : additionalConfigs) {
            JsonArray array;
            JsonProperty hints;
            JsonFile jsonFile;
            JsonObject topValue;
            PsiFile psiFile = psiManager.findFile(file);
            if (!(psiFile instanceof JsonFile) || (topValue = (JsonObject)ObjectUtils.tryCast((Object)(jsonFile = (JsonFile)psiFile).getTopLevelValue(), JsonObject.class)) == null || (hints = topValue.findProperty("hints")) == null || (array = (JsonArray)ObjectUtils.tryCast((Object)hints.getValue(), JsonArray.class)) == null) continue;
            for (JsonValue value : array.getValueList()) {
                PsiReference[] psiReferences;
                JsonStringLiteral nameValue;
                JsonProperty nameProperty;
                JsonObject object = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                if (object == null || (nameProperty = object.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.startsWith((CharSequence)nameValue.getValue(), (CharSequence)prefix) || SpringBootAdditionalConfigConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences((MethodReferencesSearch.SearchParameters)queryParameters, (PsiReference[])(psiReferences = nameValue.getReferences()))) continue;
                return;
            }
        }
    }

    protected boolean processFileSet(MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, String prefix, SpringFileSet fileSet) {
        return true;
    }
}

